/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy.automatable.ewt;

import java.awt.Component;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.common.Reflection;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableAwtComponent;
import org.ibboost.orqa.automation.java.proxy.automatable.ewt.AutomatableListView;
import org.ibboost.orqa.automation.java.proxy.automatable.ewt.AutomatableListViewRowCell;

public class AutomatableListViewRow
extends AutomatableListView {
    public static final String XNODE_NAME = "Row";
    private final int rowIndex;

    public AutomatableListViewRow(Component component, AutomatableAwtComponent<?> parent, int rowIndex) {
        super(component, parent);
        this.rowIndex = rowIndex;
    }

    @Override
    public List<AutomatableAwtComponent<?>> getChildren() throws JavaAppException {
        return (List)AutomatableListViewRow.uiSafeExecute(new Callable<List<AutomatableAwtComponent<?>>>(){

            @Override
            public List<AutomatableAwtComponent<?>> call() throws Exception {
                ArrayList children = new ArrayList();
                int columnCount = (Integer)Reflection.safeCall(AutomatableListViewRow.this.component, "getColumnCount", new Object[0]);
                for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                    children.add(new AutomatableListViewRowCell(AutomatableListViewRow.this.component, AutomatableListViewRow.this, AutomatableListViewRow.this.rowIndex, columnIndex));
                }
                return children;
            }
        });
    }

    public AutomatableListViewRowCell getChild(int columnIndex) {
        return new AutomatableListViewRowCell(this.component, this, this.rowIndex, columnIndex);
    }

    @Override
    public Rectangle getComponentRelativeBounds() throws JavaAppException {
        return this.getRowBounds(this.rowIndex);
    }

    @Override
    public void getFocus() throws JavaAppException {
        AutomatableListViewRow.assertNotUIThread();
        AutomatableListViewRow.getComponentFocus(this.component);
        this.select(true);
    }

    @Override
    public void select(boolean replace) throws JavaAppException {
        AutomatableListViewRow.uiSafeExecute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Reflection.call(AutomatableListViewRow.this.component, "setSelectedRow", Integer.TYPE, AutomatableListViewRow.this.rowIndex);
                return null;
            }
        });
    }

    @Override
    public String getName() {
        return XNODE_NAME;
    }

    @Override
    public String[] getAttributeNames() {
        return XATTR_INDEX_POSITION_SIZE;
    }

    @Override
    public String getAttributeValue(final String name) throws JavaAppException {
        return AutomatableListViewRow.uiSafeExecute(new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (name.equals("index")) {
                    return Integer.toString(AutomatableListViewRow.this.rowIndex + 1);
                }
                return AutomatableListViewRow.super.getAttributeValue(name);
            }
        });
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other) || !(other instanceof AutomatableListViewRow)) {
            return false;
        }
        return ((AutomatableListViewRow)other).rowIndex == this.rowIndex;
    }

    @Override
    public Object getValue() throws JavaAppException {
        return AutomatableListViewRow.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                List<AutomatableAwtComponent<?>> children = AutomatableListViewRow.this.getChildren();
                ArrayList<Object> results = new ArrayList<Object>();
                for (AutomatableAwtComponent<?> child : children) {
                    results.add(child.getValue());
                }
                return results;
            }
        });
    }
}

