/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy.automatable.ewt;

import java.awt.Component;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.common.Reflection;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableAwtComponent;
import org.ibboost.orqa.automation.java.proxy.automatable.ewt.AutomatableListView;
import org.ibboost.orqa.automation.java.proxy.automatable.ewt.AutomatableListViewHeader;

public class AutomatableListViewHeaderCell
extends AutomatableListView {
    public static final String XNODE_NAME = "Header";
    private final int columnIndex;

    public AutomatableListViewHeaderCell(Component listView, AutomatableListViewHeader parent, int columnIndex) {
        super(listView, (AutomatableAwtComponent<?>)parent);
        this.columnIndex = columnIndex;
    }

    @Override
    public List<AutomatableAwtComponent<?>> getChildren() {
        return new ArrayList();
    }

    @Override
    public Rectangle getComponentRelativeBounds() throws JavaAppException {
        return this.getCellBounds(-1, this.columnIndex);
    }

    @Override
    public String getName() {
        return XNODE_NAME;
    }

    @Override
    public String[] getAttributeNames() {
        return XATTR_INDEX_POSITION_SIZE_COLORS;
    }

    @Override
    public String getAttributeValue(final String name) throws JavaAppException {
        return AutomatableListViewHeaderCell.uiSafeExecute(new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (name.equals("index")) {
                    return Integer.toString(AutomatableListViewHeaderCell.this.columnIndex + 1);
                }
                return AutomatableListViewHeaderCell.super.getAttributeValue(name);
            }
        });
    }

    @Override
    public void setTextValue(final String text, final boolean append) throws JavaAppException {
        AutomatableListViewHeaderCell.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() {
                try {
                    Object oldValue;
                    Object mHeaderDataSource = Reflection.getPropertyWithReflection(AutomatableListViewHeaderCell.this.component, "mHeaderDataSource", false, null);
                    String newText = text;
                    if (append && (oldValue = Reflection.safeCall(AutomatableListViewHeaderCell.this.component, "getHeaderData", Integer.TYPE, AutomatableListViewHeaderCell.this.columnIndex)) != null && !oldValue.toString().isEmpty()) {
                        newText = oldValue.toString() + text;
                    }
                    Reflection.call(mHeaderDataSource, "setData", Integer.TYPE, AutomatableListViewHeaderCell.this.columnIndex, Object.class, newText);
                }
                catch (Exception e) {
                    throw new UnsupportedOperationException();
                }
                return null;
            }
        });
    }

    @Override
    public Object getValue() throws JavaAppException {
        return AutomatableListViewHeaderCell.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return Reflection.safeCall(AutomatableListViewHeaderCell.this.component, "getHeaderData", Integer.TYPE, AutomatableListViewHeaderCell.this.columnIndex);
            }
        });
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other) || !(other instanceof AutomatableListViewHeaderCell)) {
            return false;
        }
        return ((AutomatableListViewHeaderCell)other).columnIndex == this.columnIndex;
    }

    @Override
    public boolean isTextCurrentlyEditable() throws JavaAppException {
        return false;
    }

    @Override
    public boolean hasStringValue() {
        return true;
    }
}

