/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy.automatable.awt;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.ibboost.orqa.automation.java.common.Reflection;
import org.ibboost.orqa.automation.java.common.logging.RemoteLogger;
import sun.awt.AppContext;

public class AwtTools {
    private static final Thread SHUTDOWN_TEST = new Thread();

    public static boolean isAppShuttingDown() {
        try {
            Runtime.getRuntime().addShutdownHook(SHUTDOWN_TEST);
            Runtime.getRuntime().removeShutdownHook(SHUTDOWN_TEST);
        }
        catch (IllegalStateException e) {
            return true;
        }
        return false;
    }

    public static List<Window> getWindows() {
        LinkedHashSet<Window> windows = new LinkedHashSet<Window>();
        try {
            windows.addAll(Arrays.asList(Window.getWindows()));
        }
        catch (Throwable t) {
            RemoteLogger.error(t);
        }
        if (windows.isEmpty()) {
            try {
                for (AppContext appContext : AppContext.getAppContexts()) {
                    windows.addAll(AwtTools.getAppContextWindows(appContext));
                }
            }
            catch (Throwable t) {
                RemoteLogger.error(t);
            }
        }
        return new ArrayList<Window>(windows);
    }

    private static Set<Window> getAppContextWindows(AppContext appContext) {
        LinkedHashSet<Window> result = new LinkedHashSet<Window>();
        try {
            Window[] windows = (Window[])Reflection.staticCall(Window.class, "getWindows", AppContext.class, appContext);
            if (windows != null) {
                result.addAll(Arrays.asList(windows));
            }
        }
        catch (Throwable t) {
            RemoteLogger.error(t);
        }
        return result;
    }

    private static AppContext getApplicationContext(Window window) {
        if (window != null) {
            Set<AppContext> appContexts = AppContext.getAppContexts();
            if (appContexts.size() == 1) {
                return appContexts.iterator().next();
            }
            for (AppContext appContext : AppContext.getAppContexts()) {
                if (!AwtTools.getAppContextWindows(appContext).contains(window)) continue;
                return appContext;
            }
        }
        return AppContext.getAppContext();
    }

    public static EventQueue getApplicationEventQueue(Component eventTarget) {
        while (eventTarget != null && !(eventTarget instanceof Window) && eventTarget.getParent() != null) {
            eventTarget = eventTarget.getParent();
        }
        Window window = eventTarget instanceof Window ? (Window)eventTarget : null;
        return (EventQueue)AwtTools.getApplicationContext(window).get(AppContext.EVENT_QUEUE_KEY);
    }

    static {
        Reflection.makeAccessible(null, "sun.awt.AppContext");
    }
}

