/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy.automatable.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.ibboost.orqa.automation.events.enums.AutomatableClick;
import org.ibboost.orqa.automation.events.enums.AutomatableKey;
import org.ibboost.orqa.automation.java.common.IAutomationProxy;
import org.ibboost.orqa.automation.java.common.INodeCaptureReceiver;
import org.ibboost.orqa.automation.java.common.IRemoteEventReceiver;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.common.Reflection;
import org.ibboost.orqa.automation.java.common.logging.RemoteLogger;
import org.ibboost.orqa.automation.java.proxy.AutomationDocument;
import org.ibboost.orqa.automation.java.proxy.AutomationElement;
import org.ibboost.orqa.automation.java.proxy.AutomationTarget;
import org.ibboost.orqa.automation.java.proxy.NodeManager;
import org.ibboost.orqa.automation.java.proxy.UiThreadJobManager;
import org.ibboost.orqa.automation.java.proxy.automatable.Automatable;
import org.ibboost.orqa.automation.java.proxy.automatable.AutomationEventListener;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableAwtComponent;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AwtAutomatableKey;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AwtTools;

public class AwtEventCapture {
    private static final long EVENT_CALLBACK_TIMEOUT = 10000L;
    private static final AtomicReference<AWTEventListener> inputBlocker = new AtomicReference();
    private static final ConcurrentHashMap<UUID, AwtNodeCaptureEventListener> nodeCaptureReceivers = new ConcurrentHashMap();
    private static final ConcurrentHashMap<UUID, AwtAutomationEventListener> eventReceivers = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Component, Boolean> glassPaneVisibilityCache = new ConcurrentHashMap();
    private static final Field ID_FIELD = Reflection.safeGetDeclaredField(AWTEvent.class, "id");
    private static final Field IS_SYSTEM_GENERATED_FIELD = Reflection.safeGetDeclaredField(AWTEvent.class, "isSystemGenerated");
    private static final Field MODIFIERS_FIELD = Reflection.safeGetDeclaredField(InputEvent.class, "modifiers");

    public static void blockUserInput() throws RemoteException {
        try {
            AWTEventListener newListener = new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent event) {
                    try {
                        if (event.getClass().getName().equals("sun.awt.UngrabEvent")) {
                            try {
                                AWTEventListener el = (AWTEventListener)Reflection.getPropertyWithReflection(Toolkit.getDefaultToolkit(), "eventListener", false, null);
                                for (AWTEventListener listener : (AWTEventListener[])AWTEventMulticaster.getListeners((EventListener)el, AWTEventListener.class)) {
                                    try {
                                        AWTEventListener wrappedListener = (AWTEventListener)Reflection.call(listener, "getListener", new Object[0]);
                                        if (wrappedListener == this) continue;
                                        long eventMask = (Long)Reflection.getPropertyWithReflection(listener, "eventMask", false, null);
                                        Reflection.setPropertyWithReflection(listener, "eventMask", false, eventMask &= Integer.MAX_VALUE);
                                    }
                                    catch (Exception e) {
                                        RemoteLogger.error(e);
                                    }
                                }
                            }
                            catch (Exception e1) {
                                RemoteLogger.error(e1);
                            }
                        }
                        if (event instanceof InputEvent && IS_SYSTEM_GENERATED_FIELD.getBoolean(event)) {
                            ((InputEvent)event).consume();
                            if (event.getID() >= 500 && event.getID() <= 507) {
                                ID_FIELD.set(event, 0);
                            }
                        }
                    }
                    catch (Exception e) {
                        RemoteLogger.error(e);
                    }
                }
            };
            Toolkit.getDefaultToolkit().addAWTEventListener(newListener, -1L);
            AWTEventListener oldListener = inputBlocker.getAndSet(newListener);
            if (oldListener != null) {
                Toolkit.getDefaultToolkit().removeAWTEventListener(oldListener);
            }
        }
        catch (Exception e) {
            throw JavaAppException.wrap(e);
        }
    }

    public static void unblockUserInput() throws RemoteException {
        AWTEventListener listener = inputBlocker.getAndSet(null);
        if (listener != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(listener);
        }
    }

    private static void setGlassPaneVisibility(Component eventTarget, boolean logVerbose) {
        if (!nodeCaptureReceivers.isEmpty() || !eventReceivers.isEmpty()) {
            if (logVerbose) {
                RemoteLogger.debug("Disabling glass panes for event capture");
            }
            LinkedHashSet<Object> glassPanes = new LinkedHashSet<Object>();
            if (AutomatableAwtComponent.isCustomGlassPane(eventTarget)) {
                glassPanes.add(eventTarget);
            }
            for (Window window : AwtTools.getWindows()) {
                Component[] glassPane;
                if (window instanceof JFrame && (glassPane = ((JFrame)window).getGlassPane()) != null) {
                    glassPanes.add(glassPane);
                }
                if (logVerbose) {
                    RemoteLogger.debug(String.format("Looking for custom glass panes in sub components of window (%s)", AwtEventCapture.getLoggablePathForComponent(window)));
                }
                glassPane = window.getComponents();
                int n = glassPane.length;
                for (int i = 0; i < n; ++i) {
                    Component component = glassPane[i];
                    boolean isCustomGlassPane = AutomatableAwtComponent.isCustomGlassPane(component);
                    if (logVerbose) {
                        String extendedSimpleClassName = Automatable.getExtendedSimpleClassName(component);
                        RemoteLogger.debug(String.format("Checking subcomponent %s (%s); Glasspane: %s", extendedSimpleClassName, component.getClass().getCanonicalName(), isCustomGlassPane));
                    }
                    if (!isCustomGlassPane) continue;
                    glassPanes.add(component);
                }
            }
            for (Component component : glassPanes) {
                boolean setCache;
                boolean bl = setCache = !glassPaneVisibilityCache.containsKey(component) || component.isVisible();
                if (logVerbose || setCache) {
                    RemoteLogger.debug(String.format("Found glass pane '%s' with component path '%s' and visible status '%s'", component.getClass().getCanonicalName(), AwtEventCapture.getLoggablePathForComponent(component), component.isVisible()));
                }
                if (setCache) {
                    glassPaneVisibilityCache.put(component, component.isVisible());
                }
                if (!component.isVisible()) continue;
                component.setVisible(false);
            }
        } else {
            if (logVerbose) {
                RemoteLogger.debug("Restoring glass panes");
            }
            for (Map.Entry<Component, Boolean> entry : glassPaneVisibilityCache.entrySet()) {
                Component component = entry.getKey();
                boolean cachedVisibility = entry.getValue();
                RemoteLogger.debug(String.format("Restoring glass pane '%s' with component path '%s' to visible status '%s'", component.getClass().getCanonicalName(), AwtEventCapture.getLoggablePathForComponent(component), cachedVisibility));
                if (component.isVisible() == cachedVisibility) continue;
                component.setVisible(cachedVisibility);
            }
            glassPaneVisibilityCache.clear();
        }
    }

    private static String getLoggablePathForComponent(Component component) {
        LinkedList<Component> path = new LinkedList<Component>();
        for (Component current = component; current != null; current = current.getParent()) {
            path.add(0, current);
        }
        StringBuilder pathBuilder = new StringBuilder();
        for (Component segment : path) {
            pathBuilder.append("/").append(Automatable.getXPathNodeNameFromClass(segment.getClass()));
        }
        return pathBuilder.toString();
    }

    private static AutomationTarget automationTargetFromClickEvent(Component clickedComponent, Point clickedPoint, boolean allowVirtualComponents, boolean glassFramesSuppressed) throws JavaAppException {
        if (!glassFramesSuppressed) {
            Component rootComponent = AutomatableAwtComponent.getRootComponent(clickedComponent);
            clickedPoint = SwingUtilities.convertPoint(clickedComponent, clickedPoint, rootComponent);
            clickedComponent = rootComponent;
        }
        AutomatableAwtComponent<?> clickedComponentAutomatable = AutomatableAwtComponent.automatableFromComponent(clickedComponent);
        AutomationTarget automationTarget = clickedComponentAutomatable.getClickEventTarget(clickedPoint);
        if (allowVirtualComponents) {
            return automationTarget;
        }
        Automatable resultAutomatable = automationTarget.getAutomatable();
        Point clickOffset = new Point(automationTarget.getX(), automationTarget.getY());
        while (resultAutomatable.isVirtualComponent()) {
            Rectangle parentRelativeBounds = resultAutomatable.getParentRelativeBounds();
            resultAutomatable = resultAutomatable.getParent();
            clickOffset = new Point(clickOffset.x + parentRelativeBounds.x, clickOffset.y + parentRelativeBounds.y);
        }
        return new AutomationTarget(resultAutomatable, clickOffset.x, clickOffset.y);
    }

    public static void registerNodeCaptureReceiver(INodeCaptureReceiver receiver, boolean captureXPaths, boolean optimizeCapturedXPaths, boolean suppressGlassPanes) throws RemoteException {
        nodeCaptureReceivers.put(receiver.getId(), new AwtNodeCaptureEventListener(receiver, captureXPaths, optimizeCapturedXPaths, suppressGlassPanes));
    }

    public static void unregisterNodeCaptureReceiver(INodeCaptureReceiver receiver) throws RemoteException {
        AwtNodeCaptureEventListener listener = nodeCaptureReceivers.remove(receiver.getId());
        if (listener != null) {
            listener.dispose();
        }
    }

    public static void registerEventRecever(IRemoteEventReceiver receiver, boolean optimizeXPaths, boolean captureXmlSnapshots, boolean suppressGlassPanes) throws RemoteException {
        eventReceivers.put(receiver.getId(), new AwtAutomationEventListener(receiver, optimizeXPaths, captureXmlSnapshots, suppressGlassPanes));
    }

    public static void unregisterEventReceiver(IRemoteEventReceiver receiver) throws RemoteException {
        AwtAutomationEventListener listener = eventReceivers.remove(receiver.getId());
        if (listener != null) {
            listener.dispose();
        }
    }

    private static class AwtNodeCaptureEventListener
    implements AWTEventListener {
        private final INodeCaptureReceiver receiver;
        private final boolean captureXPaths;
        private final boolean optimizeCapturedXPaths;
        private final boolean suppressGlassPanes;
        private long eventCount = 0L;

        public AwtNodeCaptureEventListener(INodeCaptureReceiver receiver, boolean captureXPaths, boolean optimizeCapturedXPaths, boolean suppressGlassPanes) {
            this.receiver = receiver;
            this.captureXPaths = captureXPaths;
            this.optimizeCapturedXPaths = optimizeCapturedXPaths;
            this.suppressGlassPanes = suppressGlassPanes;
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 16L);
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            ++this.eventCount;
            try {
                MouseEvent mouseEvent = (MouseEvent)event;
                Component eventComponent = mouseEvent.getComponent();
                if (this.suppressGlassPanes) {
                    AwtEventCapture.setGlassPaneVisibility(eventComponent, this.eventCount == 1L);
                }
                if (event.getID() == 501 && mouseEvent.getButton() == 1 && IS_SYSTEM_GENERATED_FIELD.getBoolean(event)) {
                    if (mouseEvent.isControlDown()) {
                        try {
                            RemoteLogger.debug("Node Capture: Left click ignored due to ctrl key down");
                            MODIFIERS_FIELD.set(mouseEvent, (Integer)MODIFIERS_FIELD.get(mouseEvent) & 0xFFFFFF7F & 0xFFFFFFFD);
                        }
                        catch (Exception e) {
                            RemoteLogger.error(e);
                        }
                    } else {
                        mouseEvent.consume();
                        RemoteLogger.debug(String.format("Node Capture: Left click on component %s (Simple class: %s Full class: %s) at %d, %d", Automatable.getXPathNodeNameFromClass(eventComponent.getClass()), Automatable.getExtendedSimpleClassName(eventComponent), eventComponent.getClass().getCanonicalName(), mouseEvent.getX(), mouseEvent.getY()));
                        boolean allowVirtualComponents = (mouseEvent.getModifiersEx() & 0x40) == 0;
                        AutomationTarget clickEventTarget = AwtEventCapture.automationTargetFromClickEvent(eventComponent, mouseEvent.getPoint(), allowVirtualComponents, this.suppressGlassPanes);
                        Automatable clickEventAutomatable = clickEventTarget.getAutomatable();
                        if (!AutomatableAwtComponent.automatableFromComponent(eventComponent).equals(clickEventAutomatable)) {
                            RemoteLogger.debug(String.format("Node Capture: Sub target %s", clickEventAutomatable.getName()));
                        }
                        RemoteLogger.debug(String.format("Node Capture: Looking for component %s in automation document", clickEventAutomatable.getName()));
                        AutomationDocument document = new AutomationDocument();
                        final AutomationElement element = document.findAutomatableElement(clickEventAutomatable);
                        final String xPath = this.captureXPaths ? AutomationDocument.getNodeXPath(element, IAutomationProxy.PREFERRED_TEXT_ELEMENTS, IAutomationProxy.PREFERRED_ATTRIBUTES, this.optimizeCapturedXPaths) : null;
                        final Point clickOffset = new Point(clickEventTarget.getX(), clickEventTarget.getY());
                        UiThreadJobManager.pauseUiThreadForExternalJob(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    RemoteLogger.debug(String.format("Node Capture: Submitting xpath: %s", xPath));
                                    receiver.nodeCaptured(NodeManager.getNodeReference(element), xPath, clickOffset);
                                }
                                catch (Exception e) {
                                    RemoteLogger.error(e);
                                }
                            }
                        }, 10000L);
                    }
                }
            }
            catch (Exception e) {
                RemoteLogger.error(e);
            }
        }

        public void dispose() {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
            UiThreadJobManager.asyncRunOnUiThread(new Runnable(){

                @Override
                public void run() {
                    AwtEventCapture.setGlassPaneVisibility(null, true);
                }
            });
        }
    }

    private static class AwtAutomationEventListener
    extends AutomationEventListener
    implements AWTEventListener {
        private final boolean suppressGlassPanes;
        private Automatable lastUsedMenu;
        private long eventCount = 0L;

        public AwtAutomationEventListener(IRemoteEventReceiver receiver, boolean optimizeXPaths, boolean captureXmlSnapshots, boolean suppressGlassPanes) {
            super(receiver, optimizeXPaths, captureXmlSnapshots);
            this.suppressGlassPanes = suppressGlassPanes;
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 24L);
        }

        @Override
        public void dispose() {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
            UiThreadJobManager.asyncRunOnUiThread(new Runnable(){

                @Override
                public void run() {
                    AwtEventCapture.setGlassPaneVisibility(null, true);
                }
            });
            super.dispose();
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            ++this.eventCount;
            Component eventTarget = ((InputEvent)event).getComponent();
            if (this.suppressGlassPanes) {
                AwtEventCapture.setGlassPaneVisibility(eventTarget, this.eventCount == 1L);
            }
            int eventID = event.getID();
            try {
                AutomationTarget automationTarget;
                AutomatableClick clickType = null;
                AutomatableKey key = null;
                if (eventID == 401) {
                    KeyEvent keyEvent = (KeyEvent)event;
                    automationTarget = AutomatableAwtComponent.automatableFromComponent(eventTarget).getKeyEventTarget();
                    AwtAutomatableKey awtKey = AwtAutomatableKey.getAutomableKey(keyEvent.getKeyCode(), keyEvent.getKeyChar());
                    if (awtKey != null) {
                        key = awtKey.toAutomatableKey();
                    }
                } else if (eventID == 501) {
                    MouseEvent mouseEvent = (MouseEvent)event;
                    automationTarget = AwtEventCapture.automationTargetFromClickEvent(eventTarget, mouseEvent.getPoint(), true, this.suppressGlassPanes);
                    switch (mouseEvent.getButton()) {
                        default: {
                            clickType = mouseEvent.getClickCount() > 1 ? AutomatableClick.DOUBLE_CLICK : AutomatableClick.LEFT;
                            break;
                        }
                        case 2: {
                            clickType = AutomatableClick.MIDDLE;
                            break;
                        }
                        case 3: {
                            clickType = AutomatableClick.RIGHT;
                            break;
                        }
                    }
                } else {
                    return;
                }
                this.trackMenuUsage(automationTarget.getAutomatable());
                InputEvent inputEvent = (InputEvent)event;
                AutomationElement element = this.getElementFromAutomatable(automationTarget.getAutomatable());
                String xPath = this.xPathFromAutomationElement(element);
                this.newEvent(automationTarget, element, xPath, clickType, key, inputEvent.isControlDown(), inputEvent.isAltDown(), inputEvent.isShiftDown());
            }
            catch (Exception e) {
                RemoteLogger.error(e);
            }
        }

        private boolean isMenu(Automatable automatable) {
            return automatable.getComponent() instanceof JMenu;
        }

        private boolean isMenuItem(Automatable automatable) {
            return automatable.getComponent() instanceof JMenuItem;
        }

        private List<Automatable> getMenuParents(Automatable menuItem) {
            ArrayList<Automatable> path = new ArrayList<Automatable>();
            try {
                AutomatableAwtComponent<?> current = menuItem;
                while (this.isMenuItem(current)) {
                    if (((Automatable)(current = ((Automatable)current).getParent())).getComponent() instanceof JPopupMenu) {
                        current = AutomatableAwtComponent.automatableFromComponent(((JPopupMenu)((Automatable)current).getComponent()).getInvoker());
                    }
                    if (!this.isMenuItem(current)) continue;
                    path.add(0, current);
                }
            }
            catch (JavaAppException e) {
                RemoteLogger.error(e);
            }
            return path;
        }

        private void trackMenuUsage(Automatable automatable) {
            if (this.isMenuItem(automatable)) {
                List<Automatable> missingMenuEntries;
                List<Automatable> menuPath = this.getMenuParents(automatable);
                if (this.lastUsedMenu == null || !menuPath.contains(this.lastUsedMenu)) {
                    missingMenuEntries = menuPath;
                } else {
                    missingMenuEntries = new ArrayList<Automatable>();
                    int startIndex = menuPath.indexOf(this.lastUsedMenu);
                    for (int i = startIndex + 1; i < menuPath.size(); ++i) {
                        missingMenuEntries.add(menuPath.get(i));
                    }
                }
                for (Automatable entry : missingMenuEntries) {
                    AutomationTarget automationTarget = new AutomationTarget(entry);
                    AutomationElement element = this.getElementFromAutomatable(entry);
                    String xPath = this.xPathFromAutomationElement(element);
                    try {
                        this.newEvent(automationTarget, element, xPath, AutomatableClick.LEFT, null, false, false, false);
                    }
                    catch (Exception e) {
                        RemoteLogger.error(JavaAppException.wrap(e));
                    }
                }
                if (this.isMenu(automatable)) {
                    this.lastUsedMenu = automatable;
                }
            } else {
                this.lastUsedMenu = null;
            }
        }
    }
}

