/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy.automatable.awt;

import org.ibboost.orqa.automation.events.enums.AutomatableKey;

public enum AwtAutomatableKey {
    ENTER("Enter", '\n', 10),
    BACKSPACE("Backspace", '\b', 8),
    TAB("Tab", '\t', 9),
    ESCAPE("Escape", 27),
    SPACE("Space", ' ', 32),
    EXCLAMATION_MARK('!', 517),
    DOUBLE_QUOTE('\"', 152),
    HASH('#', 520),
    DOLLAR('$', 515),
    PERCENT('%', 0),
    AMPERSAND('&', 150),
    SINGLE_QUOTE('\'', 222),
    LEFT_PARENTHESIS('(', 519),
    RIGHT_PARENTHESIS(')', 522),
    ASTERISK('*', 151),
    PLUS('+', 521),
    COMMA(',', 44),
    MINUS('-', 45),
    PERIOD('.', 46),
    SLASH('/', 47),
    ZERO('0', 48),
    ONE('1', 49),
    TWO('2', 50),
    THREE('3', 51),
    FOUR('4', 52),
    FIVE('5', 53),
    SIX('6', 54),
    SEVEN('7', 55),
    EIGHT('8', 56),
    NINE('9', 57),
    COLON(':', 513),
    SEMI_COLON(';', 59),
    LESS_THAN('<', 153),
    EQUALS('=', 61),
    GREATER_THAN('>', 160),
    QUESTION_MARK('?', 0),
    AT('@', 512),
    A('a', 65),
    B('b', 66),
    C('c', 67),
    D('d', 68),
    E('e', 69),
    F('f', 70),
    G('g', 71),
    H('h', 72),
    I('i', 73),
    J('j', 74),
    K('k', 75),
    L('l', 76),
    M('m', 77),
    N('n', 78),
    O('o', 79),
    P('p', 80),
    Q('q', 81),
    R('r', 82),
    S('s', 83),
    T('t', 84),
    U('u', 85),
    V('v', 86),
    W('w', 87),
    X('x', 88),
    Y('y', 89),
    Z('z', 90),
    LEFT_BRACKET('[', 91),
    BACKSLASH('\\', 92),
    RIGHT_BRACKET(']', 93),
    CIRCUMFLEX('^', 514),
    UNDERSCORE('_', 523),
    BACK_QUOTE('`', 192),
    LEFT_BRACE('{', 161),
    VERTICAL_BAR('|', 0),
    RIGHT_BRACE('}', 162),
    TILDE('~', 131),
    INSERT("Insert", 155),
    DELETE("Delete", '\u007f', 127),
    PAGE_UP("Page up", 33),
    PAGE_DOWN("Page down", 34),
    END("End", 35),
    HOME("Home", 36),
    PRINT_SCREEN("Print Screen", 154),
    LEFT_ARROW("Left arrow", 37),
    RIGHT_ARROW("Right arrow", 39),
    UP_ARROW("Up arrow", 38),
    DOWN_ARROW("Down arrow", 40),
    NUMPAD_ZERO("Numpad 0", '0', 96),
    NUMPAD_ONE("Numpad 1", '1', 97),
    NUMPAD_TWO("Numpad 2", '2', 98),
    NUMPAD_THREE("Numpad 3", '3', 99),
    NUMPAD_FOUR("Numpad 4", '4', 100),
    NUMPAD_FIVE("Numpad 5", '5', 101),
    NUMPAD_SIX("Numpad 6", '6', 102),
    NUMPAD_SEVEN("Numpad 7", '7', 103),
    NUMPAD_EIGHT("Numpad 8", '8', 104),
    NUMPAD_NINE("Numpad 9", '9', 105),
    F1("F1", 112),
    F2("F2", 113),
    F3("F3", 114),
    F4("F4", 115),
    F5("F5", 116),
    F6("F6", 117),
    F7("F7", 118),
    F8("F8", 119),
    F9("F9", 120),
    F10("F10", 121),
    F11("F11", 122),
    F12("F12", 123);

    private final String readableName;
    private final char keyChar;
    private final int keyCode;

    public static AwtAutomatableKey getAutomableKey(int keyCode, char keyChar) {
        keyChar = Character.toLowerCase(keyChar);
        if (keyCode != 0) {
            for (AwtAutomatableKey key : AwtAutomatableKey.values()) {
                if (key.getKeyCode() != keyCode) continue;
                return key;
            }
        }
        if (keyChar != '\uffff') {
            for (AwtAutomatableKey key : AwtAutomatableKey.values()) {
                if (key.getKeyChar() != keyChar) continue;
                return key;
            }
        }
        return null;
    }

    private AwtAutomatableKey(char keyChar, int keyCode) {
        this(String.valueOf(keyChar).toUpperCase(), keyChar, keyCode);
    }

    private AwtAutomatableKey(String readableName, int keyCode) {
        this(readableName, '\uffff', keyCode);
    }

    private AwtAutomatableKey(String readableName, char keyChar, int keyCode) {
        this.readableName = readableName;
        this.keyChar = keyChar;
        this.keyCode = keyCode;
    }

    public AutomatableKey toAutomatableKey() {
        return AutomatableKey.valueOf(this.name());
    }

    public static AwtAutomatableKey fromAutomatableKey(AutomatableKey key) {
        return AwtAutomatableKey.valueOf(key.name());
    }

    public String toString() {
        return this.readableName;
    }

    public char getKeyChar() {
        return this.keyChar;
    }

    public int getKeyCode() {
        return this.keyCode;
    }
}

