/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy.automatable.awt;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.concurrent.Callable;
import javax.swing.text.JTextComponent;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.proxy.AutomationTarget;
import org.ibboost.orqa.automation.java.proxy.automatable.Automatable;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableAwtComponent;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableTable;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableTableCell;

public class AutomatableTextComponent
extends AutomatableAwtComponent<JTextComponent> {
    private static final String[] XATTR_NAMES = AutomatableTextComponent.appendAttributes(XATTR_NAME_POSITION_SIZE_COLORS, XATTR_ENABLED);

    public AutomatableTextComponent(JTextComponent textComponent, AutomatableAwtComponent<?> parent) {
        super(textComponent, parent);
    }

    @Override
    public void setTextValue(final String text, final boolean append) throws JavaAppException {
        AutomatableTextComponent.assertNotUIThread();
        this.getFocus();
        AutomatableTextComponent.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() {
                String oldText;
                String newText = text;
                if (append && (oldText = ((JTextComponent)AutomatableTextComponent.this.component).getText()) != null && !oldText.toString().isEmpty()) {
                    newText = oldText.toString() + text;
                }
                ((JTextComponent)AutomatableTextComponent.this.component).setText(newText);
                return null;
            }
        });
        this.getFocus();
    }

    @Override
    public Object getValue() throws JavaAppException {
        return AutomatableTextComponent.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return ((JTextComponent)AutomatableTextComponent.this.component).getText();
            }
        });
    }

    @Override
    public boolean hasStringValue() {
        return true;
    }

    @Override
    public boolean isTextCurrentlyEditable() throws JavaAppException {
        return AutomatableTextComponent.uiSafeExecute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return ((JTextComponent)AutomatableTextComponent.this.component).isEditable();
            }
        });
    }

    @Override
    public String[] getAttributeNames() {
        return XATTR_NAMES;
    }

    @Override
    public AutomationTarget getKeyEventTarget() throws JavaAppException {
        return AutomatableTextComponent.uiSafeExecute(new Callable<AutomationTarget>(){

            @Override
            public AutomationTarget call() throws Exception {
                for (Automatable currentNode = AutomatableTextComponent.this.getParent(); currentNode != null; currentNode = ((AutomatableAwtComponent)currentNode).getParent()) {
                    AutomationTarget result;
                    if (!(currentNode instanceof AutomatableTable) || !((result = currentNode.getKeyEventTarget()).getAutomatable() instanceof AutomatableTableCell)) continue;
                    return result;
                }
                return new AutomationTarget(AutomatableTextComponent.this);
            }
        });
    }

    @Override
    public AutomationTarget getClickEventTarget(final Point offset) throws JavaAppException {
        return AutomatableTextComponent.uiSafeExecute(new Callable<AutomationTarget>(){

            @Override
            public AutomationTarget call() throws Exception {
                int componentXOffset = ((JTextComponent)AutomatableTextComponent.this.component).getX();
                int componentYOffset = ((JTextComponent)AutomatableTextComponent.this.component).getY();
                for (Automatable currentNode = AutomatableTextComponent.this.getParent(); currentNode != null; currentNode = ((AutomatableAwtComponent)currentNode).getParent()) {
                    AutomationTarget result;
                    if (currentNode instanceof AutomatableTable && (result = currentNode.getClickEventTarget(new Point(offset.x + componentXOffset, offset.y + componentYOffset))).getAutomatable() instanceof AutomatableTableCell) {
                        return result;
                    }
                    Rectangle parentRelativeBounds = ((AutomatableAwtComponent)currentNode).getParentRelativeBounds();
                    componentXOffset = (int)((double)componentXOffset + parentRelativeBounds.getX());
                    componentYOffset = (int)((double)componentYOffset + parentRelativeBounds.getY());
                }
                return new AutomationTarget(AutomatableTextComponent.this, offset.x, offset.y);
            }
        });
    }
}

