/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy.automatable.awt;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.JTable;
import org.ibboost.orqa.automation.events.enums.AutomatableClick;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableAwtComponent;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableTableCell;

public class AutomatableTableRow
extends AutomatableAwtComponent<JTable> {
    public static final String XNODE_NAME = "Row";
    private final int rowIndex;

    public AutomatableTableRow(JTable table, AutomatableAwtComponent<?> parent, int rowIndex) {
        super(table, parent);
        this.rowIndex = rowIndex;
    }

    @Override
    public List<AutomatableAwtComponent<?>> getChildren() throws JavaAppException {
        return (List)AutomatableTableRow.uiSafeExecute(new Callable<List<AutomatableAwtComponent<?>>>(){

            @Override
            public List<AutomatableAwtComponent<?>> call() throws Exception {
                ArrayList children = new ArrayList();
                for (int columnIndex = 0; columnIndex < ((JTable)AutomatableTableRow.this.component).getColumnCount(); ++columnIndex) {
                    children.add(new AutomatableTableCell((JTable)AutomatableTableRow.this.component, AutomatableTableRow.this, AutomatableTableRow.this.rowIndex, columnIndex));
                }
                return children;
            }
        });
    }

    @Override
    public Rectangle getComponentRelativeBounds() throws JavaAppException {
        return AutomatableTableRow.uiSafeExecute(new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                Rectangle firstCell = ((JTable)AutomatableTableRow.this.component).getCellRect(AutomatableTableRow.this.rowIndex, 0, false);
                return new Rectangle(firstCell.x, firstCell.y, ((JTable)AutomatableTableRow.this.component).getWidth(), firstCell.height);
            }
        });
    }

    @Override
    public void select(final boolean replace) throws JavaAppException {
        AutomatableTableRow.assertNotUIThread();
        boolean componentSelected = AutomatableTableRow.uiSafeExecute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (replace) {
                    ((JTable)AutomatableTableRow.this.component).clearSelection();
                }
                return ((JTable)AutomatableTableRow.this.component).isRowSelected(AutomatableTableRow.this.rowIndex);
            }
        });
        if (!componentSelected) {
            this.click(AutomatableClick.LEFT, 0, 0, false, false, true, null);
        }
    }

    @Override
    public String getName() {
        return XNODE_NAME;
    }

    @Override
    public String[] getAttributeNames() {
        return XATTR_INDEX_POSITION_SIZE;
    }

    @Override
    public String getAttributeValue(final String name) throws JavaAppException {
        return AutomatableTableRow.uiSafeExecute(new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (name.equals("index")) {
                    return Integer.toString(AutomatableTableRow.this.rowIndex + 1);
                }
                if (name.equals("x")) {
                    return Integer.toString(AutomatableTableRow.this.getWindowRelativeBounds().x);
                }
                if (name.equals("y")) {
                    return Integer.toString(AutomatableTableRow.this.getWindowRelativeBounds().y);
                }
                if (name.equals("width")) {
                    return Integer.toString(AutomatableTableRow.this.getWindowRelativeBounds().width);
                }
                if (name.equals("height")) {
                    return Integer.toString(AutomatableTableRow.this.getWindowRelativeBounds().height);
                }
                return "";
            }
        });
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other) || !(other instanceof AutomatableTableRow)) {
            return false;
        }
        return ((AutomatableTableRow)other).rowIndex == this.rowIndex;
    }

    @Override
    public Object getValue() throws JavaAppException {
        return AutomatableTableRow.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                List<AutomatableAwtComponent<?>> children = AutomatableTableRow.this.getChildren();
                ArrayList<Object> results = new ArrayList<Object>();
                for (AutomatableAwtComponent<?> child : children) {
                    results.add(child.getValue());
                }
                return results;
            }
        });
    }
}

