/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy.automatable.awt;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.common.logging.RemoteLogger;
import org.ibboost.orqa.automation.java.proxy.AutomationTarget;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableAwtComponent;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableTableHeaderCell;

public class AutomatableTableHeader
extends AutomatableAwtComponent<JTableHeader> {
    public AutomatableTableHeader(JTableHeader table, AutomatableAwtComponent<?> parent) {
        super(table, parent);
    }

    @Override
    public List<AutomatableAwtComponent<?>> getChildren() throws JavaAppException {
        return (List)AutomatableTableHeader.uiSafeExecute(new Callable<List<AutomatableAwtComponent<?>>>(){

            @Override
            public List<AutomatableAwtComponent<?>> call() throws Exception {
                List children = AutomatableTableHeader.super.getChildren();
                try {
                    int columnCount = ((JTableHeader)AutomatableTableHeader.this.component).getColumnModel().getColumnCount();
                    for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                        children.add(new AutomatableTableHeaderCell((JTableHeader)AutomatableTableHeader.this.component, AutomatableTableHeader.this, columnIndex));
                    }
                }
                catch (Exception e) {
                    RemoteLogger.error(e);
                }
                return children;
            }
        });
    }

    @Override
    public Object getValue() throws JavaAppException {
        return AutomatableTableHeader.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                List<AutomatableAwtComponent<?>> children = AutomatableTableHeader.this.getChildren();
                ArrayList<Object> results = new ArrayList<Object>();
                for (AutomatableAwtComponent<?> child : children) {
                    results.add(child.getValue());
                }
                return results;
            }
        });
    }

    @Override
    public AutomationTarget getClickEventTarget(final Point clickOffset) throws JavaAppException {
        return AutomatableTableHeader.uiSafeExecute(new Callable<AutomationTarget>(){

            @Override
            public AutomationTarget call() throws Exception {
                int x = 0;
                TableColumnModel columnModel = ((JTableHeader)AutomatableTableHeader.this.component).getColumnModel();
                int columnCount = columnModel.getColumnCount();
                for (int i = 0; i < columnCount; ++i) {
                    int width = columnModel.getColumn(i).getWidth();
                    if (clickOffset.x >= x && clickOffset.x < x + width) {
                        AutomatableTableHeaderCell header = new AutomatableTableHeaderCell((JTableHeader)AutomatableTableHeader.this.component, AutomatableTableHeader.this, i);
                        Rectangle headerBounds = header.getComponentRelativeBounds();
                        Point newOffset = new Point(clickOffset.x - headerBounds.x, clickOffset.y - headerBounds.y);
                        return new AutomationTarget(header, newOffset.x, newOffset.y);
                    }
                    x += width;
                }
                return new AutomationTarget(AutomatableTableHeader.this);
            }
        });
    }
}

