/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy.automatable.awt;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumnModel;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.common.logging.RemoteLogger;
import org.ibboost.orqa.automation.java.proxy.AutomationTarget;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableAwtComponent;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableTableCell;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableTableRow;

public class AutomatableTable
extends AutomatableAwtComponent<JTable> {
    private static final String ROW_REFERENCE = "/Row";
    private static final String CELL_REFERENCE = "/Cell";
    private static final Pattern ROW_PATTERN = Pattern.compile("/Row\\[([0-9]+)\\]");
    private static ThreadLocal<Integer> maxRowCount = new ThreadLocal();

    public AutomatableTable(JTable table, AutomatableAwtComponent<?> parent) {
        super(table, parent);
    }

    public static void optimiseForTarget(String target) {
        if (!target.contains(ROW_REFERENCE) && !target.contains(CELL_REFERENCE)) {
            maxRowCount.set(0);
        } else {
            Matcher rowMatcher = ROW_PATTERN.matcher(target);
            if (rowMatcher.find()) {
                int rowIndex = Integer.valueOf(rowMatcher.group(1));
                while (rowMatcher.find()) {
                    rowIndex = Math.max(rowIndex, Integer.valueOf(rowMatcher.group(1)));
                }
                maxRowCount.set(rowIndex);
            }
        }
    }

    public static void resetOptimisation() {
        maxRowCount.remove();
    }

    @Override
    public List<AutomatableAwtComponent<?>> getChildren() throws JavaAppException {
        return (List)AutomatableTable.uiSafeExecute(new Callable<List<AutomatableAwtComponent<?>>>(){

            @Override
            public List<AutomatableAwtComponent<?>> call() throws Exception {
                List children = AutomatableTable.super.getChildren();
                try {
                    int rowCount = ((JTable)AutomatableTable.this.component).getRowCount();
                    if (maxRowCount.get() != null) {
                        rowCount = Math.min(rowCount, (Integer)maxRowCount.get());
                    }
                    for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                        children.add(new AutomatableTableRow((JTable)AutomatableTable.this.component, AutomatableTable.this, rowIndex));
                    }
                }
                catch (Exception e) {
                    RemoteLogger.error(e);
                }
                return children;
            }
        });
    }

    @Override
    public Object getValue() throws JavaAppException {
        return AutomatableTable.uiSafeExecute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ArrayList<List> results = new ArrayList<List>();
                ArrayList<String> header = new ArrayList<String>();
                for (int columnIndex = 0; columnIndex < ((JTable)AutomatableTable.this.component).getColumnCount(); ++columnIndex) {
                    header.add(((JTable)AutomatableTable.this.component).getColumnName(columnIndex));
                }
                results.add(header);
                for (int rowIndex = 0; rowIndex < ((JTable)AutomatableTable.this.component).getRowCount(); ++rowIndex) {
                    results.add((List)new AutomatableTableRow((JTable)AutomatableTable.this.component, AutomatableTable.this, rowIndex).getValue());
                }
                return results;
            }
        });
    }

    @Override
    public AutomationTarget getKeyEventTarget() throws JavaAppException {
        return AutomatableTable.uiSafeExecute(new Callable<AutomationTarget>(){

            @Override
            public AutomationTarget call() throws Exception {
                int column;
                int row;
                if (((JTable)AutomatableTable.this.component).isEditing()) {
                    row = ((JTable)AutomatableTable.this.component).getEditingRow();
                    column = ((JTable)AutomatableTable.this.component).getEditingColumn();
                } else {
                    ListSelectionModel rowSelectionModel = ((JTable)AutomatableTable.this.component).getSelectionModel();
                    TableColumnModel columnModel = ((JTable)AutomatableTable.this.component).getColumnModel();
                    ListSelectionModel columnSelectionModel = columnModel != null ? columnModel.getSelectionModel() : null;
                    row = rowSelectionModel != null ? rowSelectionModel.getLeadSelectionIndex() : ((JTable)AutomatableTable.this.component).getSelectedRow();
                    int n = column = columnSelectionModel != null ? columnSelectionModel.getLeadSelectionIndex() : ((JTable)AutomatableTable.this.component).getSelectedColumn();
                }
                if (row != -1 && column != -1) {
                    return new AutomationTarget(new AutomatableTableCell((JTable)AutomatableTable.this.component, new AutomatableTableRow((JTable)AutomatableTable.this.component, AutomatableTable.this, row), row, column));
                }
                return new AutomationTarget(AutomatableTable.this);
            }
        });
    }

    @Override
    public AutomationTarget getClickEventTarget(final Point clickOffset) throws JavaAppException {
        return AutomatableTable.uiSafeExecute(new Callable<AutomationTarget>(){

            @Override
            public AutomationTarget call() throws Exception {
                int column = ((JTable)AutomatableTable.this.component).columnAtPoint(clickOffset);
                int row = ((JTable)AutomatableTable.this.component).rowAtPoint(clickOffset);
                if (column != -1 && row != -1) {
                    AutomatableTableCell cell = new AutomatableTableCell((JTable)AutomatableTable.this.component, new AutomatableTableRow((JTable)AutomatableTable.this.component, AutomatableTable.this, row), row, column);
                    Rectangle cellBounds = cell.getComponentRelativeBounds();
                    Point newOffset = new Point(clickOffset.x - cellBounds.x, clickOffset.y - cellBounds.y);
                    return new AutomationTarget(cell, newOffset.x, newOffset.y);
                }
                return new AutomationTarget(AutomatableTable.this);
            }
        });
    }
}

