/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy.automatable.awt;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.JTabbedPane;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.proxy.AutomationTarget;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableAwtComponent;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableTab;

public class AutomatableTabbedPane
extends AutomatableAwtComponent<JTabbedPane> {
    public AutomatableTabbedPane(JTabbedPane pane, AutomatableAwtComponent<?> parent) {
        super(pane, parent);
    }

    @Override
    public List<AutomatableAwtComponent<?>> getChildren() throws JavaAppException {
        return (List)AutomatableTabbedPane.uiSafeExecute(new Callable<List<AutomatableAwtComponent<?>>>(){

            @Override
            public List<AutomatableAwtComponent<?>> call() throws Exception {
                List children = AutomatableTabbedPane.super.getChildren();
                for (int tabIndex = 0; tabIndex < ((JTabbedPane)AutomatableTabbedPane.this.component).getTabCount(); ++tabIndex) {
                    children.add(new AutomatableTab((JTabbedPane)AutomatableTabbedPane.this.component, AutomatableTabbedPane.this, tabIndex));
                }
                return children;
            }
        });
    }

    @Override
    public AutomationTarget getKeyEventTarget() throws JavaAppException {
        return AutomatableTabbedPane.uiSafeExecute(new Callable<AutomationTarget>(){

            @Override
            public AutomationTarget call() throws Exception {
                int index = ((JTabbedPane)AutomatableTabbedPane.this.component).getSelectedIndex();
                if (index != -1) {
                    return new AutomationTarget(new AutomatableTab((JTabbedPane)AutomatableTabbedPane.this.component, AutomatableTabbedPane.this, index));
                }
                return new AutomationTarget(AutomatableTabbedPane.this);
            }
        });
    }

    @Override
    public AutomationTarget getClickEventTarget(final Point clickOffset) throws JavaAppException {
        return AutomatableTabbedPane.uiSafeExecute(new Callable<AutomationTarget>(){

            @Override
            public AutomationTarget call() throws Exception {
                int index = ((JTabbedPane)AutomatableTabbedPane.this.component).indexAtLocation(clickOffset.x, clickOffset.y);
                if (index != -1) {
                    AutomatableTab tab = new AutomatableTab((JTabbedPane)AutomatableTabbedPane.this.component, AutomatableTabbedPane.this, index);
                    Rectangle tabBounds = tab.getComponentRelativeBounds();
                    return new AutomationTarget(tab, clickOffset.x - tabBounds.x, clickOffset.y - tabBounds.y);
                }
                return AutomatableTabbedPane.super.getClickEventTarget(clickOffset);
            }
        });
    }
}

