/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.ibboost.orqa.automation.java.common.logging.RemoteLogger;
import org.ibboost.orqa.automation.java.proxy.AppType;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.Swt;

public class UiThreadJobManager {
    private static JobQueue jobQueue;
    private static Object jobQueueLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void asyncRunOnUiThread(Runnable runnable) {
        Object object = jobQueueLock;
        synchronized (object) {
            if (jobQueue != null) {
                jobQueue.addJob(runnable);
                return;
            }
        }
        AppType appType = AppType.getDetectedAppType();
        if (appType == AppType.SWT) {
            try {
                Swt.asyncExecuteOnDisplayThread(runnable);
                return;
            }
            catch (LinkageError e) {
                RemoteLogger.error(e);
            }
        }
        SwingUtilities.invokeLater(runnable);
    }

    public static boolean isUiThread() {
        AppType appType = AppType.getDetectedAppType();
        if (appType == AppType.SWT) {
            try {
                return Swt.isDisplayThread();
            }
            catch (LinkageError e) {
                RemoteLogger.error(e);
            }
        }
        return SwingUtilities.isEventDispatchThread();
    }

    public static void assertNotUIThread() {
        if (UiThreadJobManager.isUiThread()) {
            throw new RuntimeException("This action cannot be run from the UI thread.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pauseUiThreadForExternalJob(Runnable externalJob, final long externalJobTimeout) {
        JobQueue jobQueue = new JobQueue(externalJobTimeout);
        Object object = jobQueueLock;
        synchronized (object) {
            if (!UiThreadJobManager.isUiThread()) {
                throw new RuntimeException("This operation must be called from the UI Thread");
            }
            if (UiThreadJobManager.jobQueue != null) {
                throw new RuntimeException("Invalid UI Thread Job Queue State");
            }
            UiThreadJobManager.jobQueue = jobQueue;
        }
        final Thread externalJobThread = new Thread(externalJob);
        externalJobThread.start();
        Thread externalJobMonitor = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    externalJobThread.join(externalJobTimeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (externalJobThread.isAlive()) {
                    externalJobThread.interrupt();
                }
                Object object = jobQueueLock;
                synchronized (object) {
                    try {
                        jobQueue.stop();
                    }
                    catch (Exception e) {
                        RemoteLogger.error(e);
                    }
                    jobQueue = null;
                }
            }
        };
        externalJobMonitor.start();
        jobQueue.run();
    }

    static {
        jobQueueLock = new Object();
    }

    private static class JobQueue
    implements Runnable {
        private static final Object QUEUE_TERMINATOR = new Object();
        private LinkedBlockingQueue<Object> jobs = new LinkedBlockingQueue();
        private final long jobTimeout;

        public JobQueue(long jobTimeout) {
            this.jobTimeout = jobTimeout;
        }

        @Override
        public void run() {
            Object job = null;
            try {
                while ((job = this.jobs.poll(this.jobTimeout, TimeUnit.MILLISECONDS)) != QUEUE_TERMINATOR) {
                    ((Runnable)job).run();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        public void stop() {
            try {
                this.jobs.put(QUEUE_TERMINATOR);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        public void addJob(Runnable runnable) {
            try {
                this.jobs.put(runnable);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

