/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.ibboost.orqa.automation.java.common.JavaProcessOutputConsumer;
import org.ibboost.orqa.automation.java.common.Reflection;
import org.ibboost.orqa.automation.java.common.RmiRegistryController;
import org.ibboost.orqa.automation.java.common.logging.FileLogger;
import org.ibboost.orqa.automation.java.proxy.ArgumentUtils;
import org.ibboost.orqa.automation.java.proxy.AttachCallback;
import org.ibboost.orqa.automation.java.proxy.ProxyAgent;

public class ProxyLauncher {
    private static final int VM_ATTACH_TIMEOUT = 6000;
    private static final int JPS_TIMEOUT = 6000;

    public static void main(String[] args) throws Exception {
        try {
            Integer launcherPid;
            HashMap<String, String> argMap = ArgumentUtils.parseArgs(args);
            String logFile = argMap.get("--logFile");
            FileLogger.setLogFile(logFile);
            FileLogger.info("Attacher started");
            FileLogger.info("sun.arch.data.model: " + System.getProperty("sun.arch.data.model"));
            FileLogger.info("Arguments: " + argMap);
            if (argMap.containsKey("--architecture")) {
                String architecture = argMap.get("--architecture").toLowerCase();
                if (!System.getProperty("sun.arch.data.model").toLowerCase().contains(architecture)) {
                    FileLogger.error(String.format("Attached was started with the wrong jvm, expected ", architecture));
                    System.exit(2);
                }
            }
            String agentJar = argMap.get("--agentJar");
            ArrayList<String> pidsToIgnore = new ArrayList<String>();
            if (argMap.containsKey("--pidsToIgnore")) {
                pidsToIgnore.addAll(Arrays.asList(argMap.get("--pidsToIgnore").split(",")));
            }
            if ((launcherPid = ProxyAgent.getPid()) != null) {
                pidsToIgnore.add(launcherPid.toString());
            }
            FileLogger.info("Starting RMI Registry Controller");
            RmiRegistryController registryController = new RmiRegistryController();
            Integer attachCallbackPort = registryController.getRegistryPort();
            FileLogger.info("Attach callback port is " + attachCallbackPort);
            boolean success = false;
            LinkedHashMap<String, String> agentArgs = new LinkedHashMap<String, String>();
            agentArgs.put("--attachCallbackPort", attachCallbackPort.toString());
            if (argMap.containsKey("--attach")) {
                agentArgs.put("--attach", null);
                agentArgs.put("--proxyRmiPort", argMap.get("--proxyRmiPort"));
                agentArgs.put("--sessionName", argMap.get("--sessionName"));
                if (argMap.containsKey("--pid")) {
                    String pid = argMap.get("--pid");
                    AttachCallback attachCallBack = ProxyLauncher.attach(pid, agentJar, agentArgs, attachCallbackPort, 6000L);
                    if (attachCallBack != null) {
                        success = attachCallBack.getAttachSucceeded();
                        RmiRegistryController.unbind("attachCallback", attachCallbackPort);
                    }
                } else if (argMap.containsKey("--windowName")) {
                    agentArgs.put("--windowName", argMap.get("--windowName"));
                    Map<Integer, String> virtualMachines = ProxyLauncher.jps();
                    for (Integer pid : virtualMachines.keySet()) {
                        try {
                            if (pidsToIgnore.contains(pid.toString())) continue;
                            AttachCallback attachCallBack = ProxyLauncher.attach(pid.toString(), agentJar, agentArgs, attachCallbackPort, 6000L);
                            if (attachCallBack != null) {
                                success = attachCallBack.getAttachSucceeded();
                                RmiRegistryController.unbind("attachCallback", attachCallbackPort);
                            }
                            if (!success) continue;
                            break;
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                }
            } else if (argMap.containsKey("--appDetails")) {
                Map<Integer, String> virtualMachines = ProxyLauncher.jps();
                for (Integer pid : virtualMachines.keySet()) {
                    if (pidsToIgnore.contains(pid.toString())) continue;
                    try {
                        AttachCallback attachCallBack = ProxyLauncher.attach(pid.toString(), agentJar, agentArgs, attachCallbackPort, 6000L);
                        if (attachCallBack == null) continue;
                        List<String> windows = attachCallBack.getWindowNames();
                        String javaHome = attachCallBack.getJavaHome();
                        String workingDir = attachCallBack.getWorkingDir();
                        RmiRegistryController.unbind("attachCallback", attachCallbackPort);
                        System.out.println("pid:" + pid);
                        System.out.println("jvmPath:" + javaHome);
                        System.out.println("workingDirectory:" + workingDir);
                        for (String window : windows) {
                            System.out.println("window:" + window.replaceAll("[\r\n]", ""));
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                success = true;
            }
            registryController.stopRMIRegistry();
            System.exit(success ? 0 : 1);
        }
        catch (Throwable t) {
            FileLogger.error(t);
            t.printStackTrace();
        }
    }

    private static AttachCallback attach(final String pid, final String agentJar, final Map<String, String> agentArgs, final int attachCallbackPort, long timeout) throws Throwable {
        final AtomicReference result = new AtomicReference();
        Thread attachThread = new Thread(){

            @Override
            public void run() {
                try {
                    result.set(ProxyLauncher.attach(pid, agentJar, agentArgs, attachCallbackPort));
                }
                catch (Exception e) {
                    FileLogger.error(e);
                }
            }
        };
        attachThread.start();
        attachThread.join(timeout);
        if (attachThread.isAlive()) {
            FileLogger.error("Attach timed out for Java process with PID: " + pid);
        }
        return (AttachCallback)result.get();
    }

    /*
     * Exception decompiling
     */
    private static AttachCallback attach(String pid, String agentJar, Map<String, String> agentArgs, int attachCallbackPort) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String safeGetAttachErrorProperty(Object vm, String attachErrorProperty) {
        if (vm == null) {
            return null;
        }
        try {
            Properties systemProperties = (Properties)Reflection.call(vm, "getSystemProperties", new Object[0]);
            Object error = systemProperties.get(attachErrorProperty);
            return error != null ? error.toString() : null;
        }
        catch (Throwable t) {
            FileLogger.error(t);
            return null;
        }
    }

    private static void safeDetatchVm(Object vm) {
        if (vm == null) {
            return;
        }
        try {
            Reflection.call(vm, "detach", new Object[0]);
        }
        catch (Throwable t) {
            FileLogger.error(t);
        }
    }

    private static File findJavaBinary(String name) throws IOException {
        boolean windows = System.getProperty("os.name").toLowerCase().contains("win");
        File javaHome = new File(System.getProperty("java.home")).getCanonicalFile();
        ArrayList<File> candidateLocations = new ArrayList<File>();
        if (javaHome.getName().equalsIgnoreCase("jre")) {
            candidateLocations.add(new File(javaHome, "..").getCanonicalFile());
        }
        candidateLocations.add(javaHome);
        for (File candidateLocation : candidateLocations) {
            File result = new File(candidateLocation, "bin/" + name + (windows ? ".exe" : ""));
            if (!result.isFile()) continue;
            return result;
        }
        throw new FileNotFoundException(String.format("Unable to find binary '%s' in java.home '%s'", name, javaHome));
    }

    private static Map<Integer, String> jps() throws IOException, InterruptedException {
        File jps = ProxyLauncher.findJavaBinary("jps");
        Process process = new ProcessBuilder(new String[0]).command(jps.getCanonicalPath(), "-l").start();
        JavaProcessOutputConsumer processConsumer = new JavaProcessOutputConsumer(process, true, false);
        processConsumer.awaitApplicationTermination(6000);
        if (!processConsumer.getStdErr().trim().isEmpty()) {
            throw new IOException("Error running jps: " + processConsumer.getStdErr());
        }
        LinkedHashMap<Integer, String> result = new LinkedHashMap<Integer, String>();
        for (String line : processConsumer.getStdOut().split("\n")) {
            if (!(line = line.trim()).matches("\\d+(\\s.*)?")) continue;
            String pid = line.split("\\s")[0];
            String description = line.substring(pid.length()).trim();
            result.put(Integer.parseInt(pid), description);
        }
        return result;
    }
}

