/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Window;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.ibboost.orqa.automation.java.common.IProxyCallBack;
import org.ibboost.orqa.automation.java.common.Reflection;
import org.ibboost.orqa.automation.java.common.RmiRegistryController;
import org.ibboost.orqa.automation.java.common.logging.FileLogger;
import org.ibboost.orqa.automation.java.common.logging.ILogCallback;
import org.ibboost.orqa.automation.java.common.logging.RemoteLogger;
import org.ibboost.orqa.automation.java.proxy.AppType;
import org.ibboost.orqa.automation.java.proxy.ArgumentUtils;
import org.ibboost.orqa.automation.java.proxy.AttachCallbackImpl;
import org.ibboost.orqa.automation.java.proxy.AutomationProxyImpl;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AutomatableAwtComponent;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AwtTools;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.Swt;

public class ProxyAgent {
    private static Thread standByThread;
    private static Instrumentation instrumentation;

    public static void premain(String agentArgument, Instrumentation instrumentation) {
        FileLogger.setLogFile(System.getenv("--logFile"));
        try {
            ProxyAgent.setInstrumentation(instrumentation);
            boolean webstartApp = Boolean.valueOf(System.getenv("ORQA_WEBSTART_APP"));
            if (webstartApp) {
                EventQueue.isDispatchThread();
            }
            if (System.getenv("ORQA_STANDBY_AGENT") != null) {
                standByThread = ProxyAgent.startStandByThread();
                return;
            }
            Integer port = Integer.valueOf(System.getenv("ORQA_RMI_PORT"));
            String sessionName = System.getenv("ORQA_RMI_SESSION_NAME");
            ILogCallback logCallback = (ILogCallback)RmiRegistryController.lookup("ORQA_RMI_LOG_CALLBACK", port);
            final IProxyCallBack callBacks = (IProxyCallBack)RmiRegistryController.lookup("ORQA_RMI_HOST_CLASS", port);
            final AutomationProxyImpl proxyRmi = new AutomationProxyImpl(sessionName, logCallback);
            RmiRegistryController.bind("ORQA_RMI_CLASS", port, proxyRmi);
            final boolean autoClose = Boolean.valueOf(System.getenv("ORQA_AUTO_CLOSE"));
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        callBacks.registerAttachment();
                        if (autoClose) {
                            callBacks.blockUntilHostCloses();
                            FileLogger.info("ORQA shutdown latch released.");
                            proxyRmi.shutdown(0);
                        }
                    }
                    catch (Throwable t) {
                        FileLogger.error(t);
                        FileLogger.info("RMI connection lost. Possibly unexpected ORQA shutdown.");
                        System.err.println(t);
                        proxyRmi.shutdown(0);
                    }
                }
            }).start();
        }
        catch (Throwable t) {
            System.err.println(t);
            FileLogger.error(t);
        }
    }

    private static Thread startStandByThread() {
        final Thread mainThread = Thread.currentThread();
        Thread standByThread = new Thread(){

            @Override
            public void run() {
                while (!this.isInterrupted() && (mainThread.isAlive() || Thread.getAllStackTraces().keySet().size() > 1)) {
                    try {
                        2.sleep(1000L);
                        String arguments = System.getProperty("orqaStandbyAgentArguments");
                        if (arguments == null || arguments.trim().isEmpty()) continue;
                        try {
                            ProxyAgent.attachToOrqa(arguments);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        System.setProperty("orqaStandbyAgentArguments", "");
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
        };
        standByThread.start();
        return standByThread;
    }

    public static void attachToOrqa(String arguments) throws Exception {
        Throwable error = null;
        Map<String, String> argMap = ArgumentUtils.decodeArgs(arguments);
        FileLogger.setLogFile(argMap.get("--logFile"));
        FileLogger.info("Agent started");
        FileLogger.info("Agent arguments: " + argMap);
        boolean attached = false;
        String attachFailureReason = null;
        try {
            if (argMap.containsKey("--attach")) {
                Integer orqaPort = Integer.valueOf(argMap.get("--proxyRmiPort"));
                String sessionName = argMap.get("--sessionName");
                if (argMap.containsKey("--windowName")) {
                    String windowName = argMap.get("--windowName");
                    FileLogger.info("Available Windows: " + ProxyAgent.getWindowNames());
                    attached = ProxyAgent.hasWindow(windowName);
                    if (attached) {
                        FileLogger.info("Matching window found");
                    } else {
                        FileLogger.info("Matching window not found");
                        attachFailureReason = String.format("No windows match the expression: '%s'", windowName);
                    }
                } else {
                    attached = true;
                }
                if (attached) {
                    ILogCallback logCallback = (ILogCallback)RmiRegistryController.lookup("ORQA_RMI_LOG_CALLBACK", orqaPort);
                    RmiRegistryController.bind("ORQA_RMI_CLASS", orqaPort, new AutomationProxyImpl(sessionName, logCallback));
                    FileLogger.info("Agent attached to ORQA");
                }
            }
        }
        catch (Throwable t) {
            error = t;
            FileLogger.error(t);
        }
        Integer attachCallBackPort = Integer.valueOf(argMap.get("--attachCallbackPort"));
        RmiRegistryController.bind("attachCallback", attachCallBackPort, new AttachCallbackImpl(attached, attachFailureReason, error));
        FileLogger.info("Attacher callback bound");
    }

    public static void agentmain(String agentArgument, Instrumentation instrumentation) throws Exception {
        block4: {
            try {
                ProxyAgent.setInstrumentation(instrumentation);
                if (System.getenv("ORQA_STANDBY_AGENT") != null) {
                    System.setProperty("orqaStandbyAgentArguments", agentArgument);
                    while (standByThread != null && standByThread.isAlive() && !System.getProperty("orqaStandbyAgentArguments").isEmpty()) {
                        Thread.sleep(1000L);
                    }
                    return;
                }
                ProxyAgent.attachToOrqa(agentArgument);
            }
            catch (Throwable t) {
                String errorPropertyName = ArgumentUtils.decodeArgs(agentArgument).get("--attachErrorProperty");
                if (errorPropertyName == null) break block4;
                System.setProperty(errorPropertyName, ProxyAgent.errorToString(t));
            }
        }
    }

    private static String errorToString(Throwable t) {
        StringBuilder result = new StringBuilder();
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            t.printStackTrace(printWriter);
            result.append(stringWriter);
        }
        catch (Throwable t1) {
            while (t1.getCause() != null && t1.getCause() != t1) {
                t1 = t1.getCause();
            }
            result.append(t.getClass().getCanonicalName()).append(":").append(t.getMessage());
        }
        return result.toString();
    }

    public static Integer getPid() {
        try {
            RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
            String vmName = runtime.getName();
            if (vmName.matches("[0-9]+@.*")) {
                return Integer.parseInt(vmName.substring(0, vmName.indexOf(64)));
            }
            Object vmManagement = Reflection.getPropertyWithReflection(runtime, "jvm", false, null);
            return (Integer)Reflection.safeCall(vmManagement, "getProcessId", new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean hasWindow(String windowName) {
        Pattern namePattern = Pattern.compile(windowName);
        for (String window : ProxyAgent.getWindowNames()) {
            if (!namePattern.matcher(window).matches()) continue;
            return true;
        }
        return false;
    }

    public static List<String> getWindowNames() {
        ArrayList<String> windowNames = new ArrayList<String>();
        try {
            AppType appType = AppType.getDetectedAppType();
            if (appType == AppType.AWT) {
                for (Window window : AwtTools.getWindows()) {
                    if (!(window instanceof Frame)) continue;
                    AutomatableAwtComponent<?> automatable = AutomatableAwtComponent.automatableFromComponent(window, null);
                    String windowName = automatable.getAttributeValue("title");
                    if (windowName.isEmpty()) {
                        windowName = automatable.getName();
                    }
                    windowNames.add(windowName);
                }
            } else if (appType == AppType.SWT) {
                windowNames.addAll(Swt.getWindowNames());
            }
            return windowNames;
        }
        catch (Exception e) {
            RemoteLogger.error(e);
            return windowNames;
        }
    }

    private static void setInstrumentation(Instrumentation instrumentation) {
        if (ProxyAgent.instrumentation != null) {
            return;
        }
        ProxyAgent.instrumentation = instrumentation;
        Reflection.setInstrumentation(instrumentation);
    }

    public static Instrumentation getInstrumentation() {
        return instrumentation;
    }
}

