/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import org.ibboost.orqa.automation.java.common.Reflection;

public class DebugTools {
    public static String getClassHeirarchy(Class<?> c, boolean printSuperClasses) {
        StringBuilder result = new StringBuilder();
        while (c != null && c != Object.class) {
            Class<?> current;
            Class<?>[] interfaces;
            Class<?> superClass;
            if (result.length() > 0) {
                result.append(System.getProperty("line.separator", "\n"));
            }
            StringBuilder entry = new StringBuilder();
            entry.append(c.getName());
            if (superClass != null && superClass != Object.class) {
                for (superClass = c.getSuperclass(); superClass != null && superClass != Object.class; superClass = superClass.getSuperclass()) {
                    entry.append(System.getProperty("line.separator", "\n")).append("\textends " + superClass);
                }
                entry.append(System.getProperty("line.separator", "\n"));
            }
            if ((interfaces = c.getInterfaces()).length > 0) {
                for (Class<?> implementedInterface : interfaces) {
                    entry.append(System.getProperty("line.separator", "\n")).append("\t");
                    Class<?> interfaceClass = implementedInterface;
                    while (interfaceClass != null) {
                        if (interfaceClass != implementedInterface) {
                            entry.append(" ");
                        }
                        entry.append("implements ").append(interfaceClass);
                        interfaceClass = implementedInterface.getSuperclass();
                    }
                }
                entry.append(System.getProperty("line.separator", "\n"));
            }
            StringBuilder fieldInfoBuilder = new StringBuilder();
            for (current = c; current != null; current = current.getSuperclass()) {
                String classPrefix = current == c ? "" : "(" + current.getName() + ") ";
                Field[] declaredFields = Reflection.getDeclaredFields(current);
                if (declaredFields.length <= 0) continue;
                ArrayList<String> fieldStrings = new ArrayList<String>();
                for (Field field : declaredFields) {
                    fieldStrings.add(field.toString());
                }
                Collections.sort(fieldStrings);
                for (String fieldString : fieldStrings) {
                    fieldInfoBuilder.append(System.getProperty("line.separator", "\n") + "\t\t" + classPrefix + fieldString);
                }
                fieldInfoBuilder.append(System.getProperty("line.separator", "\n"));
            }
            if (fieldInfoBuilder.length() > 0) {
                entry.append(System.getProperty("line.separator", "\n") + "\tFields:");
                entry.append((CharSequence)fieldInfoBuilder);
            }
            StringBuilder methodInfoBuilder = new StringBuilder();
            for (current = c; current != null; current = current.getSuperclass()) {
                String classPrefix = current == c ? "" : "(" + current.getName() + ") ";
                Method[] declaredMethods = Reflection.getDeclaredMethods(current);
                if (declaredMethods.length > 0) {
                    ArrayList<String> methodStrings = new ArrayList<String>();
                    for (Method method : declaredMethods) {
                        methodStrings.add(method.toString());
                    }
                    Collections.sort(methodStrings);
                    for (String methodString : methodStrings) {
                        methodInfoBuilder.append(System.getProperty("line.separator", "\n") + "\t\t" + classPrefix + methodString);
                    }
                }
                methodInfoBuilder.append(System.getProperty("line.separator", "\n"));
            }
            if (methodInfoBuilder.length() > 0) {
                entry.append(System.getProperty("line.separator", "\n") + "\tMethods:");
                entry.append((CharSequence)methodInfoBuilder);
            }
            result.append((CharSequence)entry);
            if (!printSuperClasses) break;
            c = c.getSuperclass();
        }
        return result.toString();
    }
}

