/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.proxy;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import org.ibboost.orqa.automation.java.common.logging.RemoteLogger;
import org.ibboost.orqa.automation.java.proxy.automatable.awt.AwtTools;
import org.ibboost.orqa.automation.java.proxy.automatable.swt.Swt;

public enum AppType {
    SWT,
    AWT;

    private static final AppType DEFAULT_APP_TYPE;
    private static final long MAX_APP_STARTUP_WAIT = 10000L;
    private static AppType detectedAppType;

    public static synchronized AppType getDetectedAppType() {
        if (detectedAppType == null) {
            detectedAppType = AppType.detectAppType();
            try {
                RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
                while (detectedAppType == null && runtimeMxBean.getUptime() < 10000L && !Thread.currentThread().isInterrupted()) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                    detectedAppType = AppType.detectAppType();
                }
            }
            catch (Exception e) {
                RemoteLogger.error(e);
            }
            if (detectedAppType == null) {
                return DEFAULT_APP_TYPE;
            }
        }
        return detectedAppType;
    }

    private static AppType detectAppType() {
        if (!AwtTools.getWindows().isEmpty()) {
            return AWT;
        }
        if (Swt.init() && Swt.getDefaultDisplay() != null) {
            return SWT;
        }
        return null;
    }

    static {
        DEFAULT_APP_TYPE = AWT;
    }
}

