/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.common.logging;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FileLogger {
    private static final SimpleDateFormat LOG_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss: ");
    private static File logFile;

    public static void setLogFile(String file) {
        logFile = file != null && !file.isEmpty() ? new File(file) : null;
    }

    public static void debug(String message) {
        FileLogger.log(message, LogLevel.DEBUG);
    }

    public static void info(String message) {
        FileLogger.log(message, LogLevel.INFO);
    }

    public static void warn(String message) {
        FileLogger.log(message, LogLevel.WARN);
    }

    public static void error(String message) {
        FileLogger.log(message, LogLevel.ERROR);
    }

    public static void error(Throwable e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        String message = String.valueOf(e.getLocalizedMessage()) + System.getProperty("line.separator", "\n") + stringWriter.toString();
        FileLogger.log(message, LogLevel.ERROR);
    }

    private static synchronized void log(String message, LogLevel level) {
        block13: {
            BufferedWriter writer = null;
            if (logFile == null) {
                return;
            }
            try {
                try {
                    logFile.getParentFile().mkdirs();
                    writer = new BufferedWriter(new FileWriter(logFile, true));
                    String logStamp = String.valueOf(LOG_DATE_FORMAT.format(new Date())) + level.format() + ": ";
                    String logEntry = String.valueOf(logStamp) + message.replaceAll("\n", "\n" + logStamp) + System.getProperty("line.separator", "\n");
                    writer.write(logEntry);
                    writer.flush();
                }
                catch (IOException iOException) {
                    if (writer == null) break block13;
                    try {
                        writer.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static String getChildLog(String childId) {
        if (logFile == null) {
            return null;
        }
        String fileName = logFile.getPath();
        if (fileName.toLowerCase().endsWith(".log")) {
            fileName = fileName.substring(0, fileName.length() - ".log".length());
        }
        fileName = String.valueOf(fileName) + "." + childId + ".log";
        return new File(fileName).getAbsolutePath();
    }

    private static enum LogLevel {
        DEBUG,
        INFO,
        WARN,
        ERROR;


        public String format() {
            String result = this.toString();
            while (result.length() < 5) {
                result = String.valueOf(result) + " ";
            }
            return result;
        }
    }
}

