/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.common;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ibboost.orqa.automation.java.common.JavaAppException;
import org.ibboost.orqa.automation.java.common.logging.RemoteLogger;

public class Reflection {
    private static final Map<Class<?>, Map<MethodKey, Method>> methodCache = new HashMap();
    private static final Map<Class<?>, Map<PropertyKey, Object>> propertyGetterCache = new HashMap();
    private static final Map<Class<?>, Map<PropertyKey, Object>> propertySetterCache = new HashMap();
    private static final int MIN_JAVA_JIGSAW_VERSION = 9;
    private static final Set<String> initialisedModules = new HashSet<String>();
    private static Method GET_MODULE_METHOD;
    private static Method GET_MODULE_NAME_METHOD;
    private static Method GET_UNNAMED_MODULE_METHOD;
    private static Method REDEFINE_MODULE_METHOD;
    private static Method GET_PACKAGES_METHOD;
    private static Integer javaMajorVersion;
    private static Instrumentation instrumentation;

    static {
        if (Reflection.getJavaMajorVersion() >= 9) {
            try {
                Class<?> moduleClass = Class.forName("java.lang.Module");
                GET_MODULE_METHOD = Class.class.getDeclaredMethod("getModule", new Class[0]);
                GET_MODULE_NAME_METHOD = moduleClass.getDeclaredMethod("getName", new Class[0]);
                GET_UNNAMED_MODULE_METHOD = ClassLoader.class.getDeclaredMethod("getUnnamedModule", new Class[0]);
                REDEFINE_MODULE_METHOD = Instrumentation.class.getDeclaredMethod("redefineModule", moduleClass, Set.class, Map.class, Map.class, Set.class, Map.class);
                GET_PACKAGES_METHOD = moduleClass.getDeclaredMethod("getPackages", new Class[0]);
            }
            catch (Exception e) {
                RemoteLogger.error(e);
            }
        }
    }

    public static void setInstrumentation(Instrumentation instrumentation) {
        if (Reflection.instrumentation == null) {
            Reflection.instrumentation = instrumentation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void makeAccessible(Class<?> c) {
        if (c == null || Reflection.getJavaMajorVersion() < 9 || instrumentation == null) {
            return;
        }
        try {
            Object targetModule = GET_MODULE_METHOD.invoke(c, new Object[0]);
            String moduleName = (String)GET_MODULE_NAME_METHOD.invoke(targetModule, new Object[0]);
            Set<String> set = initialisedModules;
            synchronized (set) {
                if (moduleName == null || initialisedModules.contains(moduleName)) {
                    return;
                }
                Object unnamedModule = GET_UNNAMED_MODULE_METHOD.invoke((Object)Reflection.class.getClassLoader(), new Object[0]);
                Set<Object> unnamedModuleSet = Collections.singleton(unnamedModule);
                HashMap<String, Set<Object>> extras = new HashMap<String, Set<Object>>();
                Set packages = (Set)GET_PACKAGES_METHOD.invoke(targetModule, new Object[0]);
                for (String modulePackage : packages) {
                    extras.put(modulePackage, unnamedModuleSet);
                }
                REDEFINE_MODULE_METHOD.invoke((Object)instrumentation, targetModule, unnamedModuleSet, extras, extras, Collections.emptySet(), Collections.emptyMap());
                initialisedModules.add(moduleName);
            }
        }
        catch (Exception e) {
            RemoteLogger.error(e);
        }
    }

    public static Object getNestedPropertyWithReflection(Object object, boolean onlyUsePublicMethods, Object defaultValue, String ... propertyPath) {
        Object current = object;
        try {
            int i = 0;
            while (i < propertyPath.length) {
                if (current != null) {
                    String propertyName = propertyPath[i];
                    current = Reflection.getPropertyWithReflection(current, propertyName, onlyUsePublicMethods, null);
                    if (i == propertyPath.length - 1) {
                        return current != null ? current : defaultValue;
                    }
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            RemoteLogger.debug(e);
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPropertyWithReflection(Object object, String propertyName, boolean onlyUsePublicMethods, Object value) throws UnsupportedOperationException {
        if (object == null) {
            return;
        }
        Class<?> c = object.getClass();
        Map<PropertyKey, AccessibleObject> propertyAccessorMap = Reflection.getAccessorMapForClass(c, propertySetterCache);
        PropertyKey propertyKey = new PropertyKey(propertyName, onlyUsePublicMethods);
        Map<PropertyKey, AccessibleObject> map = propertyAccessorMap;
        synchronized (map) {
            Object accessor = propertyAccessorMap.get(propertyKey);
            if (accessor == null) {
                Class<?>[] parameterTypes;
                Method method;
                int n;
                int n2;
                Method[] methodArray;
                if (propertyAccessorMap.containsKey(propertyKey)) {
                    throw new UnsupportedOperationException();
                }
                String setterName = "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
                if (onlyUsePublicMethods) {
                    Reflection.makeAccessible(c);
                    try {
                        methodArray = c.getMethods();
                        n2 = methodArray.length;
                        n = 0;
                        while (n < n2) {
                            method = methodArray[n];
                            if (method.getName().equals(setterName) && (parameterTypes = method.getParameterTypes()).length == 1 && (value == null || parameterTypes[0].isAssignableFrom(value.getClass()))) {
                                method.setAccessible(true);
                                method.invoke(object, value);
                                propertyAccessorMap.put(propertyKey, method);
                                return;
                            }
                            ++n;
                        }
                    }
                    catch (Exception e) {
                        RemoteLogger.debug(e);
                    }
                }
                while (c != null && c != Object.class) {
                    Reflection.makeAccessible(c);
                    try {
                        methodArray = c.getDeclaredMethods();
                        n2 = methodArray.length;
                        n = 0;
                        while (n < n2) {
                            method = methodArray[n];
                            if (method.getName().equals(setterName) && (parameterTypes = method.getParameterTypes()).length == 1 && (value == null || parameterTypes[0].isAssignableFrom(value.getClass()))) {
                                method.setAccessible(true);
                                method.invoke(object, value);
                                propertyAccessorMap.put(propertyKey, method);
                                return;
                            }
                            ++n;
                        }
                    }
                    catch (Exception e) {
                        RemoteLogger.debug(e);
                    }
                    try {
                        Field field = c.getDeclaredField(propertyName);
                        field.setAccessible(true);
                        field.set(object, value);
                        propertyAccessorMap.put(propertyKey, field);
                        return;
                    }
                    catch (Exception e) {
                        RemoteLogger.debug(e);
                        c = c.getSuperclass();
                    }
                }
                throw new UnsupportedOperationException();
            }
            try {
                if (accessor instanceof Field) {
                    ((Field)accessor).set(object, value);
                }
                if (accessor instanceof Method) {
                    ((Method)accessor).invoke(object, new Object[0]);
                }
            }
            catch (Exception e) {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static Object getPropertyWithReflection(Object object, String propertyName, boolean onlyUsePublicMethods, Object defaultValue) {
        if (object == null) {
            return defaultValue;
        }
        Class<?> c = object.getClass();
        return Reflection.getPropertyWithReflection(object, c, propertyName, onlyUsePublicMethods, defaultValue);
    }

    public static Object getStaticPropertyWithReflection(Class<?> c, String propertyName, boolean onlyUsePublicMethods, Object defaultValue) {
        return Reflection.getPropertyWithReflection(null, c, propertyName, onlyUsePublicMethods, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static Object getPropertyWithReflection(Object object, Class<?> c, String propertyName, boolean onlyUsePublicMethods, Object defaultValue) {
        if (c == null) {
            return defaultValue;
        }
        propertyAccessorMap = Reflection.getAccessorMapForClass(c, Reflection.propertyGetterCache);
        propertyKey = new PropertyKey(propertyName, onlyUsePublicMethods);
        var7_7 = propertyAccessorMap;
        synchronized (var7_7) {
            block24: {
                accessor = propertyAccessorMap.get(propertyKey);
                if (accessor != null) break block24;
                if (propertyAccessorMap.containsKey(propertyKey)) {
                    return defaultValue;
                }
                getterPrefixes = defaultValue instanceof Boolean != false ? Arrays.asList(new String[]{"is", "get"}) : Arrays.asList(new String[]{"get", "is"});
                getterName = String.valueOf(propertyName.substring(0, 1).toUpperCase()) + propertyName.substring(1);
                if (!onlyUsePublicMethods) ** GOTO lbl63
                Reflection.makeAccessible(c);
                result = null;
                getter = null;
                try {
                    for (String getterPrefix : getterPrefixes) {
                        try {
                            getter = c.getMethod(String.valueOf(getterPrefix) + getterName, new Class[0]);
                            break;
                        }
                        catch (NoSuchMethodException var15_24) {
                            // empty catch block
                        }
                    }
                    if (getter != null) {
                        getter.setAccessible(true);
                        result = getter.invoke(object, new Object[0]);
                    }
                }
                catch (Exception e) {
                    RemoteLogger.debug(e);
                }
                propertyAccessorMap.put(propertyKey, getter);
                return result != null ? result : defaultValue;
lbl-1000:
                // 1 sources

                {
                    Reflection.makeAccessible(c);
                    try {
                        getter = null;
                        for (String getterPrefix : getterPrefixes) {
                            try {
                                getter = c.getDeclaredMethod(String.valueOf(getterPrefix) + getterName, new Class[0]);
                                break;
                            }
                            catch (NoSuchMethodException var14_20) {
                                // empty catch block
                            }
                        }
                        if (getter != null) {
                            getter.setAccessible(true);
                            result = getter.invoke(object, new Object[0]);
                            propertyAccessorMap.put(propertyKey, getter);
                            return result != null ? result : defaultValue;
                        }
                    }
                    catch (Exception e) {
                        RemoteLogger.debug(e);
                    }
                    try {
                        field = c.getDeclaredField(propertyName);
                        field.setAccessible(true);
                        result = field.get(object);
                        propertyAccessorMap.put(propertyKey, field);
                        return result != null ? result : defaultValue;
                    }
                    catch (Exception var11_14) {
                        c = c.getSuperclass();
                    }
lbl63:
                    // 2 sources

                    ** while (c != null && c != Object.class)
                }
lbl64:
                // 1 sources

                propertyAccessorMap.put(propertyKey, null);
                return defaultValue;
            }
            result = null;
            try {
                if (accessor instanceof Field) {
                    result = ((Field)accessor).get(object);
                }
                if (accessor instanceof Method) {
                    result = ((Method)accessor).invoke(object, new Object[0]);
                }
            }
            catch (Exception e) {
                RemoteLogger.debug(e);
            }
            return result != null ? result : defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Method getMethod(Class<?> c, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Map<MethodKey, Method> methodMap = Reflection.getAccessorMapForClass(c, methodCache);
        MethodKey methodKey = new MethodKey(methodName, parameterTypes);
        Map<MethodKey, Method> map = methodMap;
        synchronized (map) {
            Method result = (Method)methodMap.get(methodKey);
            if (result == null) {
                if (methodMap.containsKey(methodKey)) {
                    throw new NoSuchMethodException();
                }
                while (c != null && c != Object.class) {
                    Reflection.makeAccessible(c);
                    try {
                        result = c.getDeclaredMethod(methodName, parameterTypes);
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        c = c.getSuperclass();
                    }
                }
                if (result != null && !result.isAccessible()) {
                    result.setAccessible(true);
                }
                methodMap.put(methodKey, result);
            }
            if (result == null) {
                throw new NoSuchMethodException(methodName);
            }
            return result;
        }
    }

    public static Field safeGetDeclaredField(Class<?> c, String name) {
        try {
            return Reflection.getDeclaredField(c, name);
        }
        catch (Exception e) {
            RemoteLogger.debug(e);
            return null;
        }
    }

    public static Field getDeclaredField(Class<?> c, String name) throws SecurityException, NoSuchFieldException {
        Reflection.makeAccessible(c);
        Field field = c.getDeclaredField(name);
        field.setAccessible(true);
        return field;
    }

    public static Field[] getDeclaredFields(Class<?> c) {
        Field[] fields;
        Reflection.makeAccessible(c);
        Field[] fieldArray = fields = c.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            field.setAccessible(true);
            ++n2;
        }
        return fields;
    }

    public static Method safeGetDeclaredMethod(Class<?> c, String name) {
        try {
            return Reflection.getDeclaredMethod(c, name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Method getDeclaredMethod(Class<?> c, String name) throws SecurityException, NoSuchMethodException {
        Reflection.makeAccessible(c);
        Method method = c.getDeclaredMethod(name, new Class[0]);
        method.setAccessible(true);
        return method;
    }

    public static Method[] getDeclaredMethods(Class<?> c) {
        Method[] methods;
        Reflection.makeAccessible(c);
        Method[] methodArray = methods = c.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            method.setAccessible(true);
            ++n2;
        }
        return methods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <K, V> Map<K, V> getAccessorMapForClass(Class<?> c, Map<Class<?>, Map<K, V>> accessorMapMap) {
        Map<Class<?>, Map<Class<?>, Map<K, V>>> map = accessorMapMap;
        synchronized (map) {
            Map<K, V> result = accessorMapMap.get(c);
            if (result == null) {
                result = new HashMap();
                accessorMapMap.put(c, result);
            }
            return result;
        }
    }

    public static Object safeCall(Object o, String methodName, Object ... arguments) {
        try {
            return Reflection.call(o, methodName, arguments);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object call(Object o, String methodName, Object ... arguments) throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Map.Entry<Class<?>[], Object[]> splitArgs = Reflection.splitArgs(arguments);
        return Reflection.getMethod(o.getClass(), methodName, splitArgs.getKey()).invoke(o, splitArgs.getValue());
    }

    public static Object callNestedMethod(Object o, String ... methods) {
        try {
            String[] stringArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                String methodName = stringArray[n2];
                o = Reflection.getMethod(o.getClass(), methodName, new Class[0]).invoke(o, new Object[0]);
                ++n2;
            }
            return o;
        }
        catch (Exception e) {
            RemoteLogger.debug(e);
            return null;
        }
    }

    public static Object safeStaticCall(Class<?> c, String methodName, Object ... arguments) {
        try {
            return Reflection.staticCall(c, methodName, arguments);
        }
        catch (Exception e) {
            RemoteLogger.debug(e);
            return null;
        }
    }

    public static Object staticCall(Class<?> c, String methodName, Object ... arguments) throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Map.Entry<Class<?>[], Object[]> splitArgs = Reflection.splitArgs(arguments);
        return Reflection.getMethod(c, methodName, splitArgs.getKey()).invoke(null, splitArgs.getValue());
    }

    public static Object newObject(Class<?> c, Object ... arguments) throws JavaAppException {
        Reflection.makeAccessible(c);
        try {
            Map.Entry<Class<?>[], Object[]> splitArgs = Reflection.splitArgs(arguments);
            Constructor<?> constructor = c.getConstructor(splitArgs.getKey());
            constructor.setAccessible(true);
            return constructor.newInstance(splitArgs.getValue());
        }
        catch (Exception e) {
            throw JavaAppException.wrap(e);
        }
    }

    public static Object newArray(Class<?> c, List<Object> contents) throws JavaAppException {
        Reflection.makeAccessible(c);
        try {
            Object array = Array.newInstance(c, contents != null ? contents.size() : 0);
            int i = 0;
            while (i < contents.size()) {
                Array.set(array, i, contents.get(i));
                ++i;
            }
            return array;
        }
        catch (Exception e) {
            throw JavaAppException.wrap(e);
        }
    }

    private static Map.Entry<Class<?>[], Object[]> splitArgs(Object ... args) {
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        int argCount = args.length / 2;
        Class[] argTypes = new Class[argCount];
        Object[] argValues = new Object[argCount];
        int i = 0;
        while (i < argCount) {
            argTypes[i] = (Class)args[i * 2];
            argValues[i] = args[i * 2 + 1];
            ++i;
        }
        return new AbstractMap.SimpleEntry<Class<?>[], Object[]>(argTypes, argValues);
    }

    public static void makeAccessible(ClassLoader c, String className) {
        try {
            Reflection.loadClass(null, className);
        }
        catch (ClassNotFoundException e) {
            RemoteLogger.error(e);
        }
    }

    public static Class<?> loadClass(ClassLoader c, String className) throws ClassNotFoundException {
        Class<?> result = null;
        result = c == null ? Class.forName(className) : c.loadClass(className);
        Reflection.makeAccessible(result);
        return result;
    }

    public static Object getOuterObject(Object o) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        if (o == null) {
            throw new NullPointerException();
        }
        Class<?> c = o.getClass();
        Reflection.makeAccessible(c);
        Field outerClassField = c.getDeclaredField("this$0");
        outerClassField.setAccessible(true);
        return outerClassField.get(o);
    }

    public static List<String> getClassHeirarchy(Object object) {
        ArrayList<String> result = new ArrayList<String>();
        if (object == null) {
            return result;
        }
        Class<?> objectClass = object.getClass();
        while (objectClass != null && objectClass != Object.class) {
            result.add(objectClass.getCanonicalName());
            objectClass = objectClass.getSuperclass();
        }
        return result;
    }

    public static boolean instanceOf(Object object, Class<?> ... classes) {
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            if (c.isInstance(object)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean instanceOfInterface(Object object, String ... targetClassNames) {
        return Reflection.instanceOf(object, true, targetClassNames);
    }

    public static boolean instanceOfClass(Object object, String ... targetClassNames) {
        return Reflection.instanceOf(object, false, targetClassNames);
    }

    public static boolean instanceOf(Object object, boolean targetClassIsInterface, String ... targetClassNames) {
        if (object == null) {
            return false;
        }
        Class<?> objectClass = object.getClass();
        while (objectClass != null && objectClass != Object.class) {
            int n;
            Reflection.makeAccessible(objectClass);
            if (targetClassIsInterface) {
                Class<?>[] classArray = objectClass.getInterfaces();
                n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> interfaceClass = classArray[n2];
                    String[] stringArray = targetClassNames;
                    int n3 = targetClassNames.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String targetClassName = stringArray[n4];
                        if (targetClassName.equals(interfaceClass.getName())) {
                            return true;
                        }
                        ++n4;
                    }
                    ++n2;
                }
            } else {
                String className = objectClass.getCanonicalName();
                if (className != null) {
                    String[] stringArray = targetClassNames;
                    int n5 = targetClassNames.length;
                    n = 0;
                    while (n < n5) {
                        String targetClassName = stringArray[n];
                        if (targetClassName.equals(className)) {
                            return true;
                        }
                        ++n;
                    }
                }
            }
            objectClass = objectClass.getSuperclass();
        }
        return false;
    }

    private static synchronized int getJavaMajorVersion() {
        int firstSegment;
        if (javaMajorVersion != null) {
            return javaMajorVersion;
        }
        String versionString = System.getProperty("java.version");
        String[] versionComponents = versionString.split("[^\\d]");
        javaMajorVersion = versionComponents.length == 0 ? Integer.valueOf(-1) : ((firstSegment = Integer.parseInt(versionComponents[0])) > 1 || versionComponents.length == 1 ? Integer.valueOf(firstSegment) : Integer.valueOf(Integer.parseInt(versionComponents[1])));
        return javaMajorVersion;
    }

    private static class MethodKey {
        private final String methodName;
        private final Class<?>[] parameterTypes;

        public MethodKey(String methodName, Class<?>[] parameterTypes) {
            this.methodName = methodName;
            this.parameterTypes = parameterTypes;
        }

        public boolean equals(Object o) {
            if (!(o instanceof MethodKey)) {
                return false;
            }
            MethodKey other = (MethodKey)o;
            return this.methodName.equals(other.methodName) && Arrays.equals(this.parameterTypes, other.parameterTypes);
        }

        public int hashCode() {
            return this.methodName.hashCode() + Arrays.hashCode(this.parameterTypes);
        }
    }

    private static class PropertyKey {
        private final String propertyName;
        private final boolean onlyUsePublicMethods;

        public PropertyKey(String propertyName, boolean onlyUsePublicMethods) {
            this.propertyName = propertyName;
            this.onlyUsePublicMethods = onlyUsePublicMethods;
        }

        public boolean equals(Object o) {
            if (!(o instanceof PropertyKey)) {
                return false;
            }
            PropertyKey other = (PropertyKey)o;
            return this.propertyName.equals(other.propertyName) && this.onlyUsePublicMethods == other.onlyUsePublicMethods;
        }

        public int hashCode() {
            return this.propertyName.hashCode() + Boolean.valueOf(this.onlyUsePublicMethods).hashCode();
        }
    }
}

