/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.common;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RMILoopbackSocketFactory
implements RMIClientSocketFactory,
RMIServerSocketFactory,
Serializable {
    private transient List<ServerSocket> openServerSockets;

    private synchronized void initOpenSocketLists() {
        if (this.openServerSockets == null) {
            this.openServerSockets = Collections.synchronizedList(new ArrayList());
        }
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return new Socket(InetAddress.getByName(null), port);
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        this.initOpenSocketLists();
        ServerSocket socket = new ServerSocket(port, 0, InetAddress.getByName(null)){

            @Override
            public synchronized void close() throws IOException {
                RMILoopbackSocketFactory.this.initOpenSocketLists();
                RMILoopbackSocketFactory.this.openServerSockets.remove(this);
                super.close();
            }
        };
        this.openServerSockets.add(socket);
        return socket;
    }

    public synchronized void closeAllOpenSockets() {
        if (this.openServerSockets != null) {
            for (ServerSocket socket : new ArrayList<ServerSocket>(this.openServerSockets)) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

