/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.common;

import java.io.File;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ProxySystemClassLoader
extends URLClassLoader {
    public static final String WRAPPED_SYSTEM_CLASSLOADER_PROPERTY = "javaProxyWrappedSystemClassLoader";
    private final ClassLoader defaultParent;
    private static final Set<String> loadedClasses = Collections.synchronizedSet(new HashSet());
    private static boolean firstRun = true;

    public ProxySystemClassLoader() {
        this((ClassLoader)null);
    }

    public ProxySystemClassLoader(ClassLoader defaultParent) {
        super(new URL[0], ProxySystemClassLoader.getParent(defaultParent));
        this.defaultParent = defaultParent;
    }

    private static ClassLoader getParent(ClassLoader defaultParent) {
        String wrappedClassLoader = System.getProperty(WRAPPED_SYSTEM_CLASSLOADER_PROPERTY);
        if (wrappedClassLoader != null && !wrappedClassLoader.isEmpty()) {
            try {
                Class<?> wrappedClassLoaderClass = defaultParent.loadClass(wrappedClassLoader);
                Constructor<?> constructor = wrappedClassLoaderClass.getDeclaredConstructor(ClassLoader.class);
                return (ClassLoader)constructor.newInstance(defaultParent);
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return defaultParent;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        boolean newclass;
        ProxySystemClassLoader.startThreadMonitor();
        Class<?> result = null;
        boolean bl = newclass = !loadedClasses.contains(name);
        if (newclass) {
            System.out.println("Class load request: " + name);
            loadedClasses.add(name);
        }
        try {
            result = super.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            if (this.defaultParent != this.getParent()) {
                result = this.defaultParent.loadClass(name);
            }
            System.err.println("Failed:");
            e.printStackTrace();
            throw e;
        }
        if (newclass) {
            System.out.println("Loaded: " + result == null ? "null" : result.toString());
        }
        return result;
    }

    private static synchronized void startThreadMonitor() {
        if (!firstRun) {
            return;
        }
        firstRun = false;
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    ProxySystemClassLoader.printAliveThreads();
                    try {
                        Thread.sleep(5000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        }, "Thread Monitor").start();
    }

    private static void printAliveThreads() {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        int numThreads = group.activeCount();
        Thread[] threads = new Thread[numThreads];
        group.enumerate(threads);
        System.out.println("Alive Threads:");
        Thread[] threadArray = threads;
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread t = threadArray[n2];
            if (t != null && t.isAlive()) {
                System.out.println("Thread name: " + t.getName());
            }
            ++n2;
        }
        System.out.println("--------------------");
    }

    public void appendToClassPathForInstrumentation(String path) {
        try {
            this.addURL(new File(path).toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

