/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.common;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ibboost.orqa.automation.java.common.JavaProcessOutputConsumer;

public class JvmTools {
    private static final Pattern JAVA_VERSION_PATTERN = Pattern.compile(".*(\\s|^)version\\s+\"?(?<version>[\\da-z-_]+(\\.[\\da-z-_]+)+)\"?(\\s|$)", 2);
    private static final int JAVA_VERSION_TIMEOUT = 5000;

    public static int getJavaMajorVersion() {
        return JvmTools.getJavaMajorVersion(System.getProperty("java.version"));
    }

    public static int getJavaMajorVersion(String version2) {
        String majorVersion;
        if (version2 == null) {
            return -1;
        }
        String[] segments = version2.split("\\.");
        String string = majorVersion = "1".equals(segments[0]) && segments.length > 1 ? segments[1] : segments[0];
        if (!majorVersion.matches("\\d+")) {
            return -1;
        }
        return Integer.parseInt(majorVersion);
    }

    public static int getJvmMajorVersion(File jvmExeFile) throws IOException, InterruptedException {
        return JvmTools.getJavaMajorVersion(JvmTools.getJvmVersion(jvmExeFile));
    }

    private static String getJvmVersion(File jvmExeFile) throws IOException, InterruptedException {
        String exeName = jvmExeFile.getName();
        String expectedExeName = "java";
        if (System.getProperty("os.name").toLowerCase().contains("win")) {
            expectedExeName = String.valueOf(expectedExeName) + ".exe";
        }
        if (!expectedExeName.equals(exeName)) {
            jvmExeFile = new File(jvmExeFile.getParentFile(), expectedExeName);
        }
        if (!jvmExeFile.isFile()) {
            return null;
        }
        Process process = new ProcessBuilder(new String[0]).command(jvmExeFile.getCanonicalPath(), "-version").start();
        JavaProcessOutputConsumer processConsumer = new JavaProcessOutputConsumer(process, true, false);
        processConsumer.awaitApplicationTermination(5000);
        String[] stringArray = processConsumer.getCombinedOut().split("\r?\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            Matcher matcher = JAVA_VERSION_PATTERN.matcher(line);
            if (matcher.find()) {
                return matcher.group(2);
            }
            ++n2;
        }
        return null;
    }

    public static boolean isJdk(String jdkPath) {
        if (jdkPath == null || jdkPath.isEmpty() || !new File(jdkPath).isDirectory()) {
            return false;
        }
        return JvmTools.findJdkComponent("bin", "jps", jdkPath) != null;
    }

    public static String findJdkComponent(String dir, String filename, String givenPath) {
        File path = new File(givenPath);
        if (!path.exists()) {
            return null;
        }
        if (!path.isDirectory()) {
            path = path.getParentFile();
        }
        if (path == null) {
            return null;
        }
        String absPath = path.getAbsolutePath();
        List<String> possibleLocations = Arrays.asList(dir, "../" + dir, ".");
        for (String location : possibleLocations) {
            ArrayList<String> filenames = new ArrayList<String>(Arrays.asList(filename));
            if (!filename.contains(".") && System.getProperty("os.name").toLowerCase().contains("win")) {
                filenames.add(String.valueOf(filename) + ".exe");
            }
            for (String name : filenames) {
                File candidate = new File(String.valueOf(absPath) + "/" + location + "/" + name);
                if (!candidate.exists()) continue;
                try {
                    return candidate.getCanonicalPath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

