/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.java.common;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ibboost.orqa.automation.java.common.Reflection;

public class JavaAppException
extends RemoteException {
    private static final long serialVersionUID = -1863676282382756805L;
    private final String stackTrace;
    private final String exceptionMessage;
    private final String exceptionLocalisedMessage;
    private final String exceptionClassDisplayName;
    private List<String> exceptionClassHeirarchy;
    private Map<String, String> exceptionProperties;

    public static JavaAppException wrap(Throwable t) {
        if (t instanceof JavaAppException) {
            return (JavaAppException)t;
        }
        return new JavaAppException(t);
    }

    protected JavaAppException(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        t.printStackTrace(printWriter);
        StringBuilder stackTraceBuilder = new StringBuilder(stringWriter.toString());
        Throwable rootCause = t;
        while (rootCause.getCause() != null && rootCause.getCause() != rootCause) {
            rootCause = rootCause.getCause();
        }
        this.exceptionMessage = rootCause.getMessage();
        this.exceptionLocalisedMessage = rootCause.getLocalizedMessage();
        if (rootCause instanceof JavaAppException) {
            JavaAppException jae = (JavaAppException)rootCause;
            String causeTrace = jae.getStackTraceAsString();
            if (causeTrace != null && !causeTrace.trim().isEmpty()) {
                stackTraceBuilder.append("Caused by: ").append(causeTrace);
            }
            this.exceptionClassDisplayName = jae.getExceptionClassDisplayName();
            this.exceptionClassHeirarchy = jae.getExceptionClassHeirarchy();
            this.exceptionProperties = jae.getExceptionProperties();
        } else {
            this.exceptionClassDisplayName = rootCause.getClass().getSimpleName();
            this.exceptionClassHeirarchy = JavaAppException.getExceptionClassHeirarchy(rootCause);
            this.exceptionProperties = JavaAppException.getExceptionProperties(rootCause);
        }
        this.stackTrace = stackTraceBuilder.toString();
    }

    public JavaAppException(String message) {
        this.exceptionMessage = message;
        this.exceptionLocalisedMessage = message;
        this.stackTrace = "";
        this.exceptionClassDisplayName = this.getClass().getSimpleName();
        this.exceptionClassHeirarchy = JavaAppException.getExceptionClassHeirarchy(this);
        this.exceptionProperties = new HashMap<String, String>();
    }

    private static List<String> getExceptionClassHeirarchy(Throwable exception) {
        ArrayList<String> result = new ArrayList<String>();
        Class<?> type = exception.getClass();
        while (type != null) {
            String className = type.getName();
            if (className != null && !className.isEmpty()) {
                result.add(className);
            }
            type = type.getSuperclass();
        }
        return result;
    }

    private static Map<String, String> getExceptionProperties(Throwable exception) {
        HashMap<String, String> exceptionProperties = new HashMap<String, String>();
        try {
            Class<?> type = exception.getClass();
            while (type != null) {
                Field[] fieldArray = Reflection.getDeclaredFields(exception.getClass());
                int n = fieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Field field = fieldArray[n2];
                    Object fieldValue = field.get(exception);
                    if (fieldValue != null) {
                        exceptionProperties.put(field.getName(), fieldValue.toString());
                    }
                    ++n2;
                }
                type = type.getSuperclass();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return exceptionProperties;
    }

    @Override
    public String getMessage() {
        return this.exceptionMessage;
    }

    @Override
    public String getLocalizedMessage() {
        return this.exceptionLocalisedMessage;
    }

    public String getExceptionClassDisplayName() {
        return this.exceptionClassDisplayName;
    }

    public List<String> getExceptionClassHeirarchy() {
        return this.exceptionClassHeirarchy;
    }

    public Map<String, String> getExceptionProperties() {
        return this.exceptionProperties;
    }

    public String getStackTraceAsString() {
        return this.stackTrace;
    }

    public static class JavaAppWarning
    extends JavaAppException {
        private static final long serialVersionUID = -735170538998948658L;
        private final Object result;

        public JavaAppWarning(String message, Object result) {
            super(message);
            this.result = result;
        }

        public Object getResult() {
            return this.result;
        }
    }
}

