/*
 * Decompiled with CFR 0.152.
 */
package org.ibboost.orqa.automation.events.enums;

public enum AutomatableKey {
    ENTER("Enter", '\n'),
    BACKSPACE("Backspace", '\b'),
    TAB("Tab", '\t'),
    ESCAPE("Escape"),
    SPACE("Space", ' '),
    EXCLAMATION_MARK('!'),
    DOUBLE_QUOTE('\"'),
    HASH('#'),
    DOLLAR('$'),
    PERCENT('%'),
    AMPERSAND('&'),
    SINGLE_QUOTE('\''),
    LEFT_PARENTHESIS('('),
    RIGHT_PARENTHESIS(')'),
    ASTERISK('*'),
    PLUS('+'),
    COMMA(','),
    MINUS('-'),
    PERIOD('.'),
    SLASH('/'),
    ZERO('0'),
    ONE('1'),
    TWO('2'),
    THREE('3'),
    FOUR('4'),
    FIVE('5'),
    SIX('6'),
    SEVEN('7'),
    EIGHT('8'),
    NINE('9'),
    COLON(':'),
    SEMI_COLON(';'),
    LESS_THAN('<'),
    EQUALS('='),
    GREATER_THAN('>'),
    QUESTION_MARK('?'),
    AT('@'),
    A('a'),
    B('b'),
    C('c'),
    D('d'),
    E('e'),
    F('f'),
    G('g'),
    H('h'),
    I('i'),
    J('j'),
    K('k'),
    L('l'),
    M('m'),
    N('n'),
    O('o'),
    P('p'),
    Q('q'),
    R('r'),
    S('s'),
    T('t'),
    U('u'),
    V('v'),
    W('w'),
    X('x'),
    Y('y'),
    Z('z'),
    LEFT_BRACKET('['),
    BACKSLASH('\\'),
    RIGHT_BRACKET(']'),
    CIRCUMFLEX('^'),
    UNDERSCORE('_'),
    BACK_QUOTE('`'),
    LEFT_BRACE('{'),
    VERTICAL_BAR('|'),
    RIGHT_BRACE('}'),
    TILDE('~'),
    INSERT("Insert"),
    DELETE("Delete", '\u007f'),
    PAGE_UP("Page up"),
    PAGE_DOWN("Page down"),
    END("End"),
    HOME("Home"),
    LEFT_ARROW("Left arrow"),
    RIGHT_ARROW("Right arrow"),
    UP_ARROW("Up arrow"),
    DOWN_ARROW("Down arrow"),
    PRINT_SCREEN("Print Screen"),
    NUMPAD_ZERO("Numpad 0", '0'),
    NUMPAD_ONE("Numpad 1", '1'),
    NUMPAD_TWO("Numpad 2", '2'),
    NUMPAD_THREE("Numpad 3", '3'),
    NUMPAD_FOUR("Numpad 4", '4'),
    NUMPAD_FIVE("Numpad 5", '5'),
    NUMPAD_SIX("Numpad 6", '6'),
    NUMPAD_SEVEN("Numpad 7", '7'),
    NUMPAD_EIGHT("Numpad 8", '8'),
    NUMPAD_NINE("Numpad 9", '9'),
    F1("F1"),
    F2("F2"),
    F3("F3"),
    F4("F4"),
    F5("F5"),
    F6("F6"),
    F7("F7"),
    F8("F8"),
    F9("F9"),
    F10("F10"),
    F11("F11"),
    F12("F12");

    private final String readableName;
    private final char keyChar;

    private AutomatableKey(char keyChar) {
        this(String.valueOf(keyChar).toUpperCase(), keyChar);
    }

    private AutomatableKey(String readableName) {
        this(readableName, '\u0000');
    }

    private AutomatableKey(String readableName, char keyChar) {
        this.readableName = readableName;
        this.keyChar = keyChar;
    }

    public String toString() {
        return this.readableName;
    }

    public char getKeyChar() {
        return this.keyChar;
    }

    public static AutomatableKey fromChar(char c) {
        AutomatableKey[] automatableKeyArray = AutomatableKey.values();
        int n = automatableKeyArray.length;
        int n2 = 0;
        while (n2 < n) {
            AutomatableKey key = automatableKeyArray[n2];
            if (Character.toUpperCase(key.keyChar) == Character.toUpperCase(c)) {
                return key;
            }
            ++n2;
        }
        return null;
    }
}

