/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.types;

import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.api.typesystem.TypeDefinition;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.types.XSNonNegativeInteger;
import info.fingo.xactus.processor.internal.types.builtin.BuiltinTypeLibrary;
import java.math.BigInteger;

public class XSUnsignedLong
extends XSNonNegativeInteger {
    private static final String XS_UNSIGNED_LONG = "xs:unsignedLong";

    public XSUnsignedLong() {
        this(BigInteger.valueOf(0L));
    }

    public XSUnsignedLong(BigInteger x) {
        super(x);
    }

    @Override
    public String string_type() {
        return XS_UNSIGNED_LONG;
    }

    @Override
    public String type_name() {
        return "unsignedLong";
    }

    @Override
    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        Item aat = arg.first();
        try {
            BigInteger bigInt = new BigInteger(aat.getStringValue());
            BigInteger min = BigInteger.valueOf(0L);
            BigInteger max = new BigInteger("18446744073709551615");
            if (bigInt.compareTo(min) < 0 || bigInt.compareTo(max) > 0) {
                throw DynamicError.cant_cast(null);
            }
            return new XSUnsignedLong(bigInt);
        }
        catch (NumberFormatException e) {
            throw DynamicError.cant_cast(null);
        }
    }

    @Override
    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_UNSIGNEDLONG;
    }
}

