/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.types;

import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.api.typesystem.TypeDefinition;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.types.XSUnsignedLong;
import info.fingo.xactus.processor.internal.types.builtin.BuiltinTypeLibrary;
import java.math.BigInteger;

public class XSUnsignedInt
extends XSUnsignedLong {
    private static final String XS_UNSIGNED_INT = "xs:unsignedInt";

    public XSUnsignedInt() {
        this(BigInteger.valueOf(0L));
    }

    public XSUnsignedInt(BigInteger x) {
        super(x);
    }

    @Override
    public String string_type() {
        return XS_UNSIGNED_INT;
    }

    @Override
    public String type_name() {
        return "unsignedInt";
    }

    @Override
    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        Item aat = arg.first();
        try {
            BigInteger bigInt = new BigInteger(aat.getStringValue());
            BigInteger min = BigInteger.valueOf(0L);
            BigInteger max = BigInteger.valueOf(0xFFFFFFFFL);
            if (bigInt.compareTo(min) < 0 || bigInt.compareTo(max) > 0) {
                throw DynamicError.cant_cast(null);
            }
            return new XSUnsignedInt(bigInt);
        }
        catch (NumberFormatException e) {
            throw DynamicError.cant_cast(null);
        }
    }

    @Override
    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_UNSIGNEDINT;
    }

    @Override
    public Number getNativeValue() {
        return this.getValue().intValue();
    }
}

