/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.types;

import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.api.typesystem.TypeDefinition;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.types.XSNormalizedString;
import info.fingo.xactus.processor.internal.types.builtin.BuiltinTypeLibrary;

public class XSToken
extends XSNormalizedString {
    private static final String XS_TOKEN = "xs:token";

    public XSToken(String x) {
        super(x);
    }

    public XSToken() {
        this(null);
    }

    @Override
    public String string_type() {
        return XS_TOKEN;
    }

    @Override
    public String type_name() {
        return "token";
    }

    @Override
    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        Item aat = arg.first();
        String srcString = aat.getStringValue();
        if (!this.isSatisfiesConstraints(srcString)) {
            DynamicError.throw_type_error();
        }
        return new XSToken(srcString);
    }

    @Override
    protected boolean isSatisfiesConstraints(String srcString) {
        boolean isToken = true;
        if (!super.isSatisfiesConstraints(srcString) || srcString.startsWith(" ") || srcString.endsWith(" ") || srcString.indexOf("  ") != -1) {
            isToken = false;
        }
        return isToken;
    }

    @Override
    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_TOKEN;
    }
}

