/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.types;

import info.fingo.xactus.api.DynamicContext;
import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.api.typesystem.TypeDefinition;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.function.CmpEq;
import info.fingo.xactus.processor.internal.function.CmpGt;
import info.fingo.xactus.processor.internal.function.CmpLt;
import info.fingo.xactus.processor.internal.function.MathMinus;
import info.fingo.xactus.processor.internal.function.MathPlus;
import info.fingo.xactus.processor.internal.types.AnyAtomicType;
import info.fingo.xactus.processor.internal.types.AnyType;
import info.fingo.xactus.processor.internal.types.CalendarType;
import info.fingo.xactus.processor.internal.types.NumericType;
import info.fingo.xactus.processor.internal.types.XSDateTime;
import info.fingo.xactus.processor.internal.types.XSDayTimeDuration;
import info.fingo.xactus.processor.internal.types.XSDuration;
import info.fingo.xactus.processor.internal.types.XSString;
import info.fingo.xactus.processor.internal.types.XSUntypedAtomic;
import info.fingo.xactus.processor.internal.types.builtin.BuiltinTypeLibrary;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;

public class XSTime
extends CalendarType
implements CmpEq,
CmpLt,
CmpGt,
MathMinus,
MathPlus,
Cloneable {
    private static final String XS_TIME = "xs:time";
    private Calendar _calendar;
    private boolean _timezoned;
    private XSDuration _tz;

    public XSTime(Calendar cal, XSDuration tz) {
        this._calendar = cal;
        this._tz = tz;
        this._timezoned = tz != null;
    }

    public XSTime() {
        this(new GregorianCalendar(TimeZone.getTimeZone("GMT")), null);
    }

    public Object clone() throws CloneNotSupportedException {
        Calendar c = (Calendar)this.calendar().clone();
        XSDuration t = this.tz();
        if (t != null) {
            t = (XSDuration)t.clone();
        }
        return new XSTime(c, t);
    }

    @Override
    public String type_name() {
        return "time";
    }

    public static CalendarType parse_time(String str) {
        String startdate = "1983-11-29T";
        XSDateTime dt = XSDateTime.parseDateTime(startdate + str);
        if (dt == null) {
            return null;
        }
        return new XSTime(dt.calendar(), dt.tz());
    }

    @Override
    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        AnyAtomicType aat = (AnyAtomicType)arg.first();
        if (!this.isCastable(aat)) {
            throw DynamicError.invalidType();
        }
        CalendarType t = this.castTime(aat);
        if (t == null) {
            throw DynamicError.cant_cast(null);
        }
        return t;
    }

    private boolean isCastable(AnyAtomicType aat) {
        if (aat instanceof XSString || aat instanceof XSUntypedAtomic) {
            return true;
        }
        if (aat instanceof XSDateTime) {
            return true;
        }
        return aat instanceof XSTime;
    }

    private CalendarType castTime(AnyAtomicType aat) {
        if (aat instanceof XSTime) {
            XSTime time = (XSTime)aat;
            return new XSTime(time.calendar(), time.tz());
        }
        if (aat instanceof XSDateTime) {
            XSDateTime dateTime = (XSDateTime)aat;
            return new XSTime(dateTime.calendar(), dateTime.tz());
        }
        return XSTime.parse_time(aat.getStringValue());
    }

    public int hour() {
        return this._calendar.get(11);
    }

    public int minute() {
        return this._calendar.get(12);
    }

    public double second() {
        double s = this._calendar.get(13);
        double ms = this._calendar.get(14);
        return s += (ms /= 1000.0);
    }

    public boolean timezoned() {
        return this._timezoned;
    }

    @Override
    public String getStringValue() {
        String ret = "";
        Calendar adjustFortimezone = this.calendar();
        ret = ret + XSDateTime.pad_int(adjustFortimezone.get(11), 2);
        ret = ret + ":";
        ret = ret + XSDateTime.pad_int(adjustFortimezone.get(12), 2);
        ret = ret + ":";
        int isecond = (int)this.second();
        double sec = this.second();
        ret = sec - (double)isecond == 0.0 ? ret + XSDateTime.pad_int(isecond, 2) : (sec < 10.0 ? ret + "0" + sec : ret + sec);
        if (this.timezoned()) {
            int hrs = this._tz.hours();
            int min = this._tz.minutes();
            double secs = this._tz.seconds();
            if (hrs == 0 && min == 0 && secs == 0.0) {
                ret = ret + "Z";
            } else {
                String tZoneStr = "";
                tZoneStr = this._tz.negative() ? tZoneStr + "-" : tZoneStr + "+";
                tZoneStr = tZoneStr + XSDateTime.pad_int(hrs, 2);
                tZoneStr = tZoneStr + ":";
                tZoneStr = tZoneStr + XSDateTime.pad_int(min, 2);
                ret = ret + tZoneStr;
            }
        }
        return ret;
    }

    @Override
    public String string_type() {
        return XS_TIME;
    }

    @Override
    public Calendar calendar() {
        return this._calendar;
    }

    public XSDuration tz() {
        return this._tz;
    }

    public double value() {
        return (double)this.calendar().getTimeInMillis() / 1000.0;
    }

    @Override
    public boolean eq(AnyType arg, DynamicContext dynamicContext) throws DynamicError {
        XSTime val = (XSTime)NumericType.get_single_type(arg, XSTime.class);
        Calendar thiscal = this.normalizeCalendar(this.calendar(), this.tz());
        Calendar thatcal = this.normalizeCalendar(val.calendar(), val.tz());
        return thiscal.equals(thatcal);
    }

    @Override
    public boolean lt(AnyType arg, DynamicContext context) throws DynamicError {
        XSTime val = (XSTime)NumericType.get_single_type(arg, XSTime.class);
        Calendar thiscal = this.normalizeCalendar(this.calendar(), this.tz());
        Calendar thatcal = this.normalizeCalendar(val.calendar(), val.tz());
        return thiscal.before(thatcal);
    }

    @Override
    public boolean gt(AnyType arg, DynamicContext context) throws DynamicError {
        XSTime val = (XSTime)NumericType.get_single_type(arg, XSTime.class);
        Calendar thiscal = this.normalizeCalendar(this.calendar(), this.tz());
        Calendar thatcal = this.normalizeCalendar(val.calendar(), val.tz());
        return thiscal.after(thatcal);
    }

    @Override
    public ResultSequence minus(ResultSequence arg) throws DynamicError {
        Item at;
        if (arg.size() != 1) {
            DynamicError.throw_type_error();
        }
        if (!((at = arg.first()) instanceof XSTime) && !(at instanceof XSDayTimeDuration)) {
            throw DynamicError.throw_type_error();
        }
        if (at instanceof XSTime) {
            return this.minusXSTimeDuration(at);
        }
        if (at instanceof XSDayTimeDuration) {
            return this.minusXSDayTimeDuration(at);
        }
        return null;
    }

    private ResultSequence minusXSDayTimeDuration(Item at) {
        XSDuration val = (XSDuration)at;
        XSTime res = null;
        try {
            res = (XSTime)this.clone();
        }
        catch (CloneNotSupportedException err) {
            return null;
        }
        XMLGregorianCalendar xmlCal = _datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)this.calendar());
        Duration dtduration = _datatypeFactory.newDuration(val.getStringValue());
        xmlCal.add(dtduration.negate());
        res = new XSTime(xmlCal.toGregorianCalendar(), res.tz());
        return res;
    }

    private ResultSequence minusXSTimeDuration(Item at) {
        XSTime val = (XSTime)at;
        Duration dtduration = null;
        Calendar thisCal = this.normalizeCalendar(this.calendar(), this.tz());
        Calendar thatCal = this.normalizeCalendar(val.calendar(), val.tz());
        long duration = thisCal.getTimeInMillis() - thatCal.getTimeInMillis();
        dtduration = _datatypeFactory.newDuration(duration);
        return XSDayTimeDuration.parseDTDuration(dtduration.toString());
    }

    @Override
    public ResultSequence plus(ResultSequence arg) throws DynamicError {
        XSDuration val = (XSDuration)NumericType.get_single_type(arg, XSDayTimeDuration.class);
        try {
            double ms = val.time_value() * 1000.0;
            XSTime res = (XSTime)this.clone();
            res.calendar().add(14, (int)ms);
            return res;
        }
        catch (CloneNotSupportedException err) {
            assert (false);
            return null;
        }
    }

    @Override
    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_TIME;
    }

    @Override
    public Object getNativeValue() {
        return this._calendar.clone();
    }
}

