/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.types;

import info.fingo.xactus.api.DynamicContext;
import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.api.typesystem.TypeDefinition;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.function.CmpEq;
import info.fingo.xactus.processor.internal.function.CmpGt;
import info.fingo.xactus.processor.internal.function.CmpLt;
import info.fingo.xactus.processor.internal.function.FnCompare;
import info.fingo.xactus.processor.internal.types.AnyType;
import info.fingo.xactus.processor.internal.types.CtrType;
import info.fingo.xactus.processor.internal.types.builtin.BuiltinTypeLibrary;
import java.math.BigInteger;

public class XSString
extends CtrType
implements CmpEq,
CmpGt,
CmpLt {
    private static final String XS_STRING = "xs:string";
    private String _value;

    public XSString(String x) {
        this._value = x;
    }

    public XSString() {
        this(null);
    }

    @Override
    public String string_type() {
        return XS_STRING;
    }

    @Override
    public String type_name() {
        return "string";
    }

    @Override
    public String getStringValue() {
        return this._value;
    }

    public String value() {
        return this.getStringValue();
    }

    @Override
    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        Item aat = arg.first();
        return new XSString(aat.getStringValue());
    }

    private int do_compare(AnyType arg, DynamicContext dc) throws DynamicError {
        if (arg == null) {
            return 666;
        }
        XSString comparand = arg instanceof XSString ? (XSString)arg : new XSString(arg.getStringValue());
        BigInteger result = FnCompare.compare_string(dc.getCollationProvider().getDefaultCollation(), this, comparand, dc);
        return result.intValue();
    }

    @Override
    public boolean eq(AnyType arg, DynamicContext dynamicContext) throws DynamicError {
        int cmp = this.do_compare(arg, dynamicContext);
        if (cmp == 666) assert (false);
        return cmp == 0;
    }

    @Override
    public boolean gt(AnyType arg, DynamicContext context) throws DynamicError {
        int cmp = this.do_compare(arg, context);
        assert (cmp != 666);
        return cmp > 0;
    }

    @Override
    public boolean lt(AnyType arg, DynamicContext context) throws DynamicError {
        int cmp = this.do_compare(arg, context);
        assert (cmp != 666);
        return cmp < 0;
    }

    @Override
    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_STRING;
    }

    @Override
    public Object getNativeValue() {
        return this._value;
    }
}

