/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.types;

import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.api.typesystem.TypeDefinition;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.types.XSNonNegativeInteger;
import info.fingo.xactus.processor.internal.types.builtin.BuiltinTypeLibrary;
import java.math.BigInteger;

public class XSPositiveInteger
extends XSNonNegativeInteger {
    private static final String XS_POSITIVE_INTEGER = "xs:positiveInteger";

    public XSPositiveInteger() {
        this(BigInteger.valueOf(1L));
    }

    public XSPositiveInteger(BigInteger x) {
        super(x);
    }

    @Override
    public String string_type() {
        return XS_POSITIVE_INTEGER;
    }

    @Override
    public String type_name() {
        return "positiveInteger";
    }

    @Override
    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        Item aat = arg.first();
        try {
            BigInteger bigInt = new BigInteger(aat.getStringValue());
            BigInteger min = BigInteger.valueOf(1L);
            if (bigInt.compareTo(min) < 0) {
                throw DynamicError.cant_cast(null);
            }
            return new XSPositiveInteger(bigInt);
        }
        catch (NumberFormatException e) {
            throw DynamicError.cant_cast(null);
        }
    }

    @Override
    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_POSITIVEINTEGER;
    }
}

