/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.types;

import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.api.typesystem.TypeDefinition;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.types.XSString;
import info.fingo.xactus.processor.internal.types.builtin.BuiltinTypeLibrary;

public class XSNormalizedString
extends XSString {
    private static final String XS_NORMALIZEDSTRING = "xs:normalizedString";

    public XSNormalizedString(String x) {
        super(x);
    }

    public XSNormalizedString() {
        this(null);
    }

    @Override
    public String string_type() {
        return XS_NORMALIZEDSTRING;
    }

    @Override
    public String type_name() {
        return "normalizedString";
    }

    @Override
    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        Item aat = arg.first();
        String srcString = aat.getStringValue();
        if (!this.isSatisfiesConstraints(srcString)) {
            DynamicError.throw_type_error();
        }
        return new XSNormalizedString(srcString);
    }

    protected boolean isSatisfiesConstraints(String srcString) {
        boolean isNormalizedStr = true;
        if (srcString.indexOf("\r") != -1 || srcString.indexOf("\n") != -1 || srcString.indexOf("\t") != -1) {
            isNormalizedStr = false;
        }
        return isNormalizedStr;
    }

    @Override
    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_NORMALIZEDSTRING;
    }
}

