/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.types;

import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.api.typesystem.TypeDefinition;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.types.XSInteger;
import info.fingo.xactus.processor.internal.types.builtin.BuiltinTypeLibrary;
import java.math.BigInteger;

public class XSNonNegativeInteger
extends XSInteger {
    private static final String XS_NON_NEGATIVE_INTEGER = "xs:nonNegativeInteger";

    public XSNonNegativeInteger() {
        this(BigInteger.valueOf(0L));
    }

    public XSNonNegativeInteger(BigInteger x) {
        super(x);
    }

    @Override
    public String string_type() {
        return XS_NON_NEGATIVE_INTEGER;
    }

    @Override
    public String type_name() {
        return "nonNegativeInteger";
    }

    @Override
    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        Item aat = arg.first();
        try {
            BigInteger bigInt = new BigInteger(aat.getStringValue());
            BigInteger min = BigInteger.valueOf(0L);
            if (bigInt.compareTo(min) < 0) {
                throw DynamicError.cant_cast(null);
            }
            return new XSNonNegativeInteger(bigInt);
        }
        catch (NumberFormatException e) {
            throw DynamicError.cant_cast(null);
        }
    }

    @Override
    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_NONNEGATIVEINTEGER;
    }
}

