/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.types;

import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.api.typesystem.TypeDefinition;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.types.AnyAtomicType;
import info.fingo.xactus.processor.internal.types.XSName;
import info.fingo.xactus.processor.internal.types.builtin.BuiltinTypeLibrary;
import org.apache.xerces.util.XMLChar;

public class XSNCName
extends XSName {
    private static final String XS_NC_NAME = "xs:NCName";

    public XSNCName(String x) {
        super(x);
    }

    public XSNCName() {
        this(null);
    }

    @Override
    public String string_type() {
        return XS_NC_NAME;
    }

    @Override
    public String type_name() {
        return "NCName";
    }

    @Override
    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        AnyAtomicType aat = (AnyAtomicType)arg.first();
        String strValue = aat.getStringValue();
        if (!this.isConstraintSatisfied(strValue)) {
            DynamicError.throw_type_error();
        }
        return new XSNCName(strValue);
    }

    protected boolean isConstraintSatisfied(String strValue) {
        boolean isValidNCName = true;
        if (!XMLChar.isValidNCName(strValue)) {
            isValidNCName = false;
        }
        return isValidNCName;
    }

    @Override
    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_NCNAME;
    }
}

