/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.types;

import info.fingo.xactus.api.DynamicContext;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.api.typesystem.TypeDefinition;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.function.CmpEq;
import info.fingo.xactus.processor.internal.types.AnyAtomicType;
import info.fingo.xactus.processor.internal.types.AnyType;
import info.fingo.xactus.processor.internal.types.CalendarType;
import info.fingo.xactus.processor.internal.types.CtrType;
import info.fingo.xactus.processor.internal.types.NumericType;
import info.fingo.xactus.processor.internal.types.XSAnyURI;
import info.fingo.xactus.processor.internal.types.XSBase64Binary;
import info.fingo.xactus.processor.internal.types.XSBoolean;
import info.fingo.xactus.processor.internal.types.XSDuration;
import info.fingo.xactus.processor.internal.types.XSString;
import info.fingo.xactus.processor.internal.types.XSUntypedAtomic;
import info.fingo.xactus.processor.internal.types.builtin.BuiltinTypeLibrary;
import java.nio.charset.StandardCharsets;
import org.apache.xerces.impl.dv.util.Base64;
import org.apache.xerces.impl.dv.util.HexBin;

public class XSHexBinary
extends CtrType
implements CmpEq {
    private static final String XS_HEX_BINARY = "xs:hexBinary";
    private String _value;

    public XSHexBinary(String x) {
        this._value = x;
    }

    public XSHexBinary() {
        this(null);
    }

    @Override
    public String string_type() {
        return XS_HEX_BINARY;
    }

    @Override
    public String type_name() {
        return "hexBinary";
    }

    @Override
    public String getStringValue() {
        return this._value.toUpperCase();
    }

    public String value() {
        return this._value;
    }

    @Override
    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        AnyAtomicType aat = (AnyAtomicType)arg.first();
        if (aat instanceof NumericType || aat instanceof XSDuration || aat instanceof CalendarType || aat instanceof XSBoolean || aat instanceof XSAnyURI) {
            throw DynamicError.invalidType();
        }
        String str_value = aat.getStringValue();
        if (!(aat instanceof XSHexBinary || aat instanceof XSString || aat instanceof XSUntypedAtomic || aat instanceof XSBase64Binary)) {
            throw DynamicError.cant_cast(null);
        }
        if (aat instanceof XSUntypedAtomic || aat instanceof XSString) {
            String[] nonHexValues = null;
            try {
                nonHexValues = str_value.split("[0-9a-fA-F]");
            }
            catch (Exception ex) {
                throw DynamicError.throw_type_error();
            }
            String[] binValues = null;
            try {
                binValues = str_value.split("[0-1]");
            }
            catch (Exception ex) {
                throw DynamicError.throw_type_error();
            }
            if (nonHexValues.length > 0 || binValues.length == 0) {
                throw DynamicError.invalidForCastConstructor();
            }
        }
        byte[] decodedValue = null;
        if (aat instanceof XSBase64Binary) {
            decodedValue = Base64.decode(str_value);
            decodedValue = HexBin.encode(decodedValue).getBytes();
        } else {
            decodedValue = str_value.getBytes();
        }
        if (decodedValue != null) {
            return new XSHexBinary(new String(decodedValue, StandardCharsets.UTF_8));
        }
        throw DynamicError.throw_type_error();
    }

    @Override
    public boolean eq(AnyType arg, DynamicContext dynamicContext) throws DynamicError {
        String valToCompare = arg.getStringValue();
        byte[] value1 = HexBin.decode(this._value);
        byte[] value2 = HexBin.decode(valToCompare);
        if (value2 == null) {
            return false;
        }
        int len = value1.length;
        if (len != value2.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (value1[i] == value2[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_HEXBINARY;
    }

    @Override
    public Object getNativeValue() {
        return HexBin.decode(this._value);
    }
}

