/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.types;

import info.fingo.xactus.api.DynamicContext;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.api.typesystem.TypeDefinition;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.function.CmpEq;
import info.fingo.xactus.processor.internal.types.AnyAtomicType;
import info.fingo.xactus.processor.internal.types.AnyType;
import info.fingo.xactus.processor.internal.types.CalendarType;
import info.fingo.xactus.processor.internal.types.NumericType;
import info.fingo.xactus.processor.internal.types.XSAnyURI;
import info.fingo.xactus.processor.internal.types.XSBase64Binary;
import info.fingo.xactus.processor.internal.types.XSBoolean;
import info.fingo.xactus.processor.internal.types.XSDate;
import info.fingo.xactus.processor.internal.types.XSDateTime;
import info.fingo.xactus.processor.internal.types.XSDuration;
import info.fingo.xactus.processor.internal.types.XSHexBinary;
import info.fingo.xactus.processor.internal.types.XSString;
import info.fingo.xactus.processor.internal.types.XSTime;
import info.fingo.xactus.processor.internal.types.XSUntypedAtomic;
import info.fingo.xactus.processor.internal.types.builtin.BuiltinTypeLibrary;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class XSGMonthDay
extends CalendarType
implements CmpEq {
    private static final String XS_G_MONTH_DAY = "xs:gMonthDay";
    private Calendar _calendar;
    private boolean _timezoned;
    private XSDuration _tz;

    public XSGMonthDay(Calendar cal, XSDuration tz) {
        this._calendar = cal;
        if (tz != null) {
            this._timezoned = true;
            this._tz = tz;
        }
    }

    public XSGMonthDay() {
        this(new GregorianCalendar(TimeZone.getTimeZone("GMT")), null);
    }

    @Override
    public String type_name() {
        return "gMonthDay";
    }

    public static XSGMonthDay parse_gMonthDay(String str) {
        String startdate = "1972-";
        String starttime = "T00:00:00";
        int index = str.lastIndexOf(43, str.length());
        if (index == -1) {
            index = str.lastIndexOf(45);
        }
        if (index == -1) {
            index = str.lastIndexOf(90, str.length());
        }
        if (index != -1) {
            int zIndex = str.lastIndexOf(90, str.length());
            if (zIndex == -1 && index > 5) {
                zIndex = index;
            }
            if (zIndex == -1) {
                zIndex = str.lastIndexOf(43);
            }
            String[] split = str.split("-");
            startdate = startdate + split[2].replaceAll("Z", "") + "-" + split[3].replaceAll("Z", "").substring(0, 2);
            if (split.length > 4) {
                String[] timesplit = split[4].split(":");
                if (timesplit.length < 3) {
                    starttime = "T";
                    StringBuffer buf = new StringBuffer(starttime);
                    for (int cnt = 0; cnt < timesplit.length; ++cnt) {
                        buf.append(timesplit[cnt] + ":");
                    }
                    buf.append("00");
                    starttime = buf.toString();
                } else {
                    starttime = starttime + timesplit[0] + ":" + timesplit[1] + ":" + timesplit[2];
                }
            }
            startdate = startdate.trim();
            startdate = startdate + starttime;
            if (zIndex != -1) {
                startdate = startdate + str.substring(zIndex);
            }
        } else {
            startdate = startdate + starttime;
        }
        XSDateTime dt = XSDateTime.parseDateTime(startdate);
        if (dt == null) {
            return null;
        }
        return new XSGMonthDay(dt.calendar(), dt.tz());
    }

    @Override
    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        AnyAtomicType aat = (AnyAtomicType)arg.first();
        if (aat instanceof NumericType || aat instanceof XSDuration || aat instanceof XSTime || this.isGDataType(aat) || aat instanceof XSBoolean || aat instanceof XSBase64Binary || aat instanceof XSHexBinary || aat instanceof XSAnyURI) {
            throw DynamicError.invalidType();
        }
        if (!this.isCastable(aat)) {
            throw DynamicError.cant_cast(null);
        }
        XSGMonthDay val = this.castGMonthDay(aat);
        if (val == null) {
            throw DynamicError.cant_cast(null);
        }
        return val;
    }

    protected boolean isGDataType(AnyAtomicType aat) {
        String type = aat.string_type();
        return type.equals("xs:gDay") || type.equals("xs:gMonth") || type.equals("xs:gYear") || type.equals("xs:gYearMonth");
    }

    private boolean isCastable(AnyAtomicType aat) {
        if (aat instanceof XSString || aat instanceof XSUntypedAtomic) {
            return true;
        }
        if (aat instanceof XSTime) {
            return false;
        }
        return aat instanceof XSDate || aat instanceof XSDateTime || aat instanceof XSGMonthDay;
    }

    private XSGMonthDay castGMonthDay(AnyAtomicType aat) {
        if (aat instanceof XSGMonthDay) {
            XSGMonthDay gmd = (XSGMonthDay)aat;
            return new XSGMonthDay(gmd.calendar(), gmd.tz());
        }
        if (aat instanceof XSDate) {
            XSDate date = (XSDate)aat;
            return new XSGMonthDay(date.calendar(), date.tz());
        }
        if (aat instanceof XSDateTime) {
            XSDateTime dateTime = (XSDateTime)aat;
            return new XSGMonthDay(dateTime.calendar(), dateTime.tz());
        }
        return XSGMonthDay.parse_gMonthDay(aat.getStringValue());
    }

    public int month() {
        return this._calendar.get(2) + 1;
    }

    public int day() {
        return this._calendar.get(5);
    }

    public boolean timezoned() {
        return this._timezoned;
    }

    @Override
    public String getStringValue() {
        String ret = "--";
        Calendar adjustFortimezone = this.calendar();
        ret = ret + XSDateTime.pad_int(this.month(), 2);
        ret = ret + "-";
        ret = ret + XSDateTime.pad_int(adjustFortimezone.get(5), 2);
        if (this.timezoned()) {
            int hrs = this.tz().hours();
            int min = this.tz().minutes();
            double secs = this.tz().seconds();
            if (hrs == 0 && min == 0 && secs == 0.0) {
                ret = ret + "Z";
            } else {
                String tZoneStr = "";
                tZoneStr = this.tz().negative() ? tZoneStr + "-" : tZoneStr + "+";
                tZoneStr = tZoneStr + XSDateTime.pad_int(hrs, 2);
                tZoneStr = tZoneStr + ":";
                tZoneStr = tZoneStr + XSDateTime.pad_int(min, 2);
                ret = ret + tZoneStr;
            }
        }
        return ret;
    }

    @Override
    public String string_type() {
        return XS_G_MONTH_DAY;
    }

    @Override
    public Calendar calendar() {
        return this._calendar;
    }

    @Override
    public boolean eq(AnyType arg, DynamicContext dynamicContext) throws DynamicError {
        XSGMonthDay val = (XSGMonthDay)NumericType.get_single_type(arg, XSGMonthDay.class);
        return this.calendar().equals(val.calendar());
    }

    public XSDuration tz() {
        return this._tz;
    }

    @Override
    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_GMONTHDAY;
    }
}

