/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.types;

import info.fingo.xactus.api.DynamicContext;
import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.api.typesystem.TypeDefinition;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.types.AnyType;
import info.fingo.xactus.processor.internal.types.CalendarType;
import info.fingo.xactus.processor.internal.types.NaNable;
import info.fingo.xactus.processor.internal.types.NodeType;
import info.fingo.xactus.processor.internal.types.NumericType;
import info.fingo.xactus.processor.internal.types.XPathDecimalFormat;
import info.fingo.xactus.processor.internal.types.XSAnyURI;
import info.fingo.xactus.processor.internal.types.XSBase64Binary;
import info.fingo.xactus.processor.internal.types.XSBoolean;
import info.fingo.xactus.processor.internal.types.XSDuration;
import info.fingo.xactus.processor.internal.types.XSHexBinary;
import info.fingo.xactus.processor.internal.types.XSInteger;
import info.fingo.xactus.processor.internal.types.builtin.BuiltinTypeLibrary;
import java.math.BigDecimal;

public class XSFloat
extends NumericType
implements NaNable {
    private static final String XS_FLOAT = "xs:float";
    private Float _value;

    public XSFloat(float x) {
        this._value = new Float(x);
    }

    public XSFloat() {
        this(0.0f);
    }

    public XSFloat(String init) throws DynamicError {
        try {
            this._value = init.equals("-INF") ? new Float(Float.NEGATIVE_INFINITY) : (init.equals("INF") ? new Float(Float.POSITIVE_INFINITY) : new Float(init));
        }
        catch (NumberFormatException e) {
            throw DynamicError.cant_cast(null);
        }
    }

    @Override
    public String string_type() {
        return XS_FLOAT;
    }

    @Override
    public String type_name() {
        return "float";
    }

    @Override
    public String getStringValue() {
        if (this.zero()) {
            return "0";
        }
        if (this.negativeZero()) {
            return "-0";
        }
        if (this.nan()) {
            return "NaN";
        }
        return XPathDecimalFormat.xpathFormat(this._value);
    }

    @Override
    public boolean nan() {
        return Float.isNaN(this._value.floatValue());
    }

    public boolean infinite() {
        return Float.isInfinite(this._value.floatValue());
    }

    @Override
    public boolean zero() {
        return Float.compare(this._value.floatValue(), 0.0f) == 0;
    }

    public boolean negativeZero() {
        return Float.compare(this._value.floatValue(), -0.0f) == 0;
    }

    @Override
    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        AnyType aat = (AnyType)arg.first();
        if (aat instanceof XSDuration || aat instanceof CalendarType || aat instanceof XSBase64Binary || aat instanceof XSHexBinary || aat instanceof XSAnyURI) {
            throw DynamicError.invalidType();
        }
        if (!(aat.string_type().equals("xs:string") || aat instanceof NodeType || aat.string_type().equals("xs:untypedAtomic") || aat.string_type().equals("xs:boolean") || aat instanceof NumericType)) {
            throw DynamicError.cant_cast(null);
        }
        try {
            float f = aat.getStringValue().equals("INF") ? Float.POSITIVE_INFINITY : (aat.getStringValue().equals("-INF") ? Float.NEGATIVE_INFINITY : (aat instanceof XSBoolean ? (aat.getStringValue().equals("true") ? 1.0f : 0.0f) : Float.valueOf(aat.getStringValue()).floatValue()));
            return new XSFloat(f);
        }
        catch (NumberFormatException e) {
            throw DynamicError.cant_cast(null);
        }
    }

    public float float_value() {
        return this._value.floatValue();
    }

    @Override
    public boolean eq(AnyType aa, DynamicContext dynamicContext) throws DynamicError {
        Item carg = this.convertArg(aa);
        if (!(carg instanceof XSFloat)) {
            DynamicError.throw_type_error();
        }
        XSFloat f = (XSFloat)carg;
        if (this.nan() && f.nan()) {
            return false;
        }
        Float thatvalue = new Float(f.float_value());
        Float thisvalue = new Float(this.float_value());
        return thisvalue.equals(thatvalue);
    }

    @Override
    public boolean gt(AnyType arg, DynamicContext context) throws DynamicError {
        Item carg = this.convertArg(arg);
        XSFloat val = (XSFloat)XSFloat.get_single_type(carg, XSFloat.class);
        return this.float_value() > val.float_value();
    }

    @Override
    public boolean lt(AnyType arg, DynamicContext context) throws DynamicError {
        Item carg = this.convertArg(arg);
        XSFloat val = (XSFloat)XSFloat.get_single_type(carg, XSFloat.class);
        return this.float_value() < val.float_value();
    }

    @Override
    public ResultSequence plus(ResultSequence arg) throws DynamicError {
        ResultSequence carg = this.convertResultSequence(arg);
        Item at = this.get_single_arg(carg);
        if (!(at instanceof XSFloat)) {
            DynamicError.throw_type_error();
        }
        XSFloat val = (XSFloat)at;
        return new XSFloat(this.float_value() + val.float_value());
    }

    @Override
    public ResultSequence minus(ResultSequence arg) throws DynamicError {
        ResultSequence carg = this.constructor(arg);
        Item at = this.get_single_arg(carg);
        if (!(at instanceof XSFloat)) {
            DynamicError.throw_type_error();
        }
        XSFloat val = (XSFloat)at;
        return new XSFloat(this.float_value() - val.float_value());
    }

    @Override
    public ResultSequence times(ResultSequence arg) throws DynamicError {
        ResultSequence carg = this.constructor(arg);
        XSFloat val = (XSFloat)XSFloat.get_single_type(carg, XSFloat.class);
        return new XSFloat(this.float_value() * val.float_value());
    }

    @Override
    public ResultSequence div(ResultSequence arg) throws DynamicError {
        ResultSequence carg = this.convertResultSequence(arg);
        XSFloat val = (XSFloat)XSFloat.get_single_type(carg, XSFloat.class);
        return new XSFloat(this.float_value() / val.float_value());
    }

    @Override
    public ResultSequence idiv(ResultSequence arg) throws DynamicError {
        ResultSequence carg = this.convertResultSequence(arg);
        XSFloat val = (XSFloat)XSFloat.get_single_type(carg, XSFloat.class);
        if (this.nan() || val.nan()) {
            throw DynamicError.numeric_overflow("Dividend or divisor is NaN");
        }
        if (this.infinite()) {
            throw DynamicError.numeric_overflow("Dividend is infinite");
        }
        if (val.zero()) {
            throw DynamicError.div_zero(null);
        }
        BigDecimal result = BigDecimal.valueOf(new Float(this.float_value() / val.float_value()).longValue());
        return new XSInteger(result.toBigInteger());
    }

    @Override
    public ResultSequence mod(ResultSequence arg) throws DynamicError {
        ResultSequence carg = this.convertResultSequence(arg);
        XSFloat val = (XSFloat)XSFloat.get_single_type(carg, XSFloat.class);
        return new XSFloat(this.float_value() % val.float_value());
    }

    @Override
    public ResultSequence unary_minus() {
        return new XSFloat(-1.0f * this.float_value());
    }

    @Override
    public NumericType abs() {
        return new XSFloat(Math.abs(this.float_value()));
    }

    @Override
    public NumericType ceiling() {
        return new XSFloat((float)Math.ceil(this.float_value()));
    }

    @Override
    public NumericType floor() {
        return new XSFloat((float)Math.floor(this.float_value()));
    }

    @Override
    public NumericType round() {
        BigDecimal value = new BigDecimal(this.float_value());
        BigDecimal round = value.setScale(0, 4);
        return new XSFloat(round.floatValue());
    }

    @Override
    public NumericType round_half_to_even() {
        return this.round_half_to_even(0);
    }

    @Override
    public NumericType round_half_to_even(int precision) {
        BigDecimal value = new BigDecimal(this._value.floatValue());
        BigDecimal round = value.setScale(precision, 6);
        return new XSFloat(round.floatValue());
    }

    protected Item convertArg(AnyType arg) throws DynamicError {
        ResultSequence rs = arg;
        rs = this.constructor(rs);
        Item carg = rs.first();
        return carg;
    }

    @Override
    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_FLOAT;
    }

    @Override
    public Object getNativeValue() {
        return Float.valueOf(this.float_value());
    }
}

