/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.types;

import info.fingo.xactus.api.DynamicContext;
import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.api.typesystem.TypeDefinition;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.function.CmpEq;
import info.fingo.xactus.processor.internal.function.CmpGt;
import info.fingo.xactus.processor.internal.function.CmpLt;
import info.fingo.xactus.processor.internal.function.MathMinus;
import info.fingo.xactus.processor.internal.function.MathPlus;
import info.fingo.xactus.processor.internal.types.AnyType;
import info.fingo.xactus.processor.internal.types.CalendarType;
import info.fingo.xactus.processor.internal.types.NodeType;
import info.fingo.xactus.processor.internal.types.NumericType;
import info.fingo.xactus.processor.internal.types.XSDateTime;
import info.fingo.xactus.processor.internal.types.XSDayTimeDuration;
import info.fingo.xactus.processor.internal.types.XSDuration;
import info.fingo.xactus.processor.internal.types.XSString;
import info.fingo.xactus.processor.internal.types.XSTime;
import info.fingo.xactus.processor.internal.types.XSUntypedAtomic;
import info.fingo.xactus.processor.internal.types.XSYearMonthDuration;
import info.fingo.xactus.processor.internal.types.builtin.BuiltinTypeLibrary;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;

public class XSDate
extends CalendarType
implements CmpEq,
CmpLt,
CmpGt,
MathMinus,
MathPlus,
Cloneable {
    private static final String XS_DATE = "xs:date";
    private Calendar _calendar;
    private boolean _timezoned;
    private XSDuration _tz;

    public XSDate(Calendar cal, XSDuration tz) {
        this._calendar = cal;
        this._tz = tz;
        this._timezoned = tz != null;
    }

    public XSDate() {
        this(new GregorianCalendar(TimeZone.getTimeZone("GMT")), null);
    }

    @Override
    public String type_name() {
        return "date";
    }

    public Object clone() throws CloneNotSupportedException {
        Calendar c = (Calendar)this.calendar().clone();
        XSDuration t = this.tz();
        if (t != null) {
            t = (XSDuration)t.clone();
        }
        return new XSDate(c, t);
    }

    public static XSDate parse_date(String str) {
        String date = "";
        String time = "T00:00:00.0";
        int index = str.indexOf(43, 1);
        if (index == -1) {
            index = str.indexOf(45, 1);
            if (index == -1) {
                return null;
            }
            if ((index = str.indexOf(45, index + 1)) == -1) {
                return null;
            }
            index = str.indexOf(45, index + 1);
        }
        if (index == -1) {
            index = str.indexOf(90, 1);
        }
        if (index != -1) {
            date = str.substring(0, index);
            date = date + time;
            date = date + str.substring(index, str.length());
        } else {
            date = str + time;
        }
        XSDateTime dt = XSDateTime.parseDateTime(date);
        if (dt == null) {
            return null;
        }
        return new XSDate(dt.calendar(), dt.tz());
    }

    @Override
    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        Item aat = arg.first();
        if (!this.isCastable(aat)) {
            throw DynamicError.invalidType();
        }
        XSDate dt = this.castDate(aat);
        if (dt == null) {
            throw DynamicError.cant_cast(null);
        }
        return dt;
    }

    private boolean isCastable(Item aat) {
        if (aat instanceof XSString || aat instanceof XSUntypedAtomic || aat instanceof NodeType) {
            return true;
        }
        if (aat instanceof XSTime) {
            return false;
        }
        if (aat instanceof XSDateTime) {
            return true;
        }
        return aat instanceof XSDate;
    }

    private XSDate castDate(Item aat) {
        if (aat instanceof XSDate) {
            XSDate date = (XSDate)aat;
            return new XSDate(date.calendar(), date.tz());
        }
        if (aat instanceof XSDateTime) {
            XSDateTime dateTime = (XSDateTime)aat;
            return new XSDate(dateTime.calendar(), dateTime.tz());
        }
        return XSDate.parse_date(aat.getStringValue());
    }

    public int year() {
        int y = this._calendar.get(1);
        if (this._calendar.get(0) == 0) {
            y *= -1;
        }
        return y;
    }

    public int month() {
        return this._calendar.get(2) + 1;
    }

    public int day() {
        return this._calendar.get(5);
    }

    public boolean timezoned() {
        return this._timezoned;
    }

    @Override
    public String getStringValue() {
        String ret = "";
        Calendar adjustFortimezone = this.calendar();
        if (adjustFortimezone.get(0) == 0) {
            ret = ret + "-";
        }
        ret = ret + XSDateTime.pad_int(adjustFortimezone.get(1), 4);
        ret = ret + "-";
        ret = ret + XSDateTime.pad_int(this.month(), 2);
        ret = ret + "-";
        ret = ret + XSDateTime.pad_int(adjustFortimezone.get(5), 2);
        if (this.timezoned()) {
            int hrs = this._tz.hours();
            int min = this._tz.minutes();
            double secs = this._tz.seconds();
            if (hrs == 0 && min == 0 && secs == 0.0) {
                ret = ret + "Z";
            } else {
                String tZoneStr = "";
                tZoneStr = this._tz.negative() ? tZoneStr + "-" : tZoneStr + "+";
                tZoneStr = tZoneStr + XSDateTime.pad_int(hrs, 2);
                tZoneStr = tZoneStr + ":";
                tZoneStr = tZoneStr + XSDateTime.pad_int(min, 2);
                ret = ret + tZoneStr;
            }
        }
        return ret;
    }

    @Override
    public String string_type() {
        return XS_DATE;
    }

    @Override
    public Calendar calendar() {
        return this._calendar;
    }

    public XSDuration tz() {
        return this._tz;
    }

    @Override
    public boolean eq(AnyType arg, DynamicContext dynamicContext) throws DynamicError {
        XSDate val = (XSDate)NumericType.get_single_type((Item)arg, XSDate.class);
        Calendar thiscal = this.normalizeCalendar(this.calendar(), this.tz());
        Calendar thatcal = this.normalizeCalendar(val.calendar(), val.tz());
        return thiscal.equals(thatcal);
    }

    @Override
    public boolean lt(AnyType arg, DynamicContext context) throws DynamicError {
        XSDate val = (XSDate)NumericType.get_single_type((Item)arg, XSDate.class);
        Calendar thiscal = this.normalizeCalendar(this.calendar(), this.tz());
        Calendar thatcal = this.normalizeCalendar(val.calendar(), val.tz());
        return thiscal.before(thatcal);
    }

    @Override
    public boolean gt(AnyType arg, DynamicContext context) throws DynamicError {
        XSDate val = (XSDate)NumericType.get_single_type((Item)arg, XSDate.class);
        Calendar thiscal = this.normalizeCalendar(this.calendar(), this.tz());
        Calendar thatcal = this.normalizeCalendar(val.calendar(), val.tz());
        return thiscal.after(thatcal);
    }

    public double value() {
        return (double)this.calendar().getTimeInMillis() / 1000.0;
    }

    @Override
    public ResultSequence minus(ResultSequence arg) throws DynamicError {
        if (arg.size() != 1) {
            throw DynamicError.throw_type_error();
        }
        Item at = arg.first();
        if (!(at instanceof XSDate || at instanceof XSYearMonthDuration || at instanceof XSDayTimeDuration)) {
            throw DynamicError.throw_type_error();
        }
        if (at instanceof XSDate) {
            return this.minusXSDate(arg);
        }
        if (at instanceof XSYearMonthDuration) {
            return this.minusXSYearMonthDuration((XSYearMonthDuration)at);
        }
        if (at instanceof XSDayTimeDuration) {
            return this.minusXSDayTimeDuration((XSDayTimeDuration)at);
        }
        return null;
    }

    private ResultSequence minusXSDayTimeDuration(AnyType at) {
        XSDuration val = (XSDuration)at;
        try {
            XSDate res = (XSDate)this.clone();
            XMLGregorianCalendar xmlCal = _datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)this.calendar());
            Duration dtduration = _datatypeFactory.newDuration(val.getStringValue());
            xmlCal.add(dtduration.negate());
            res = new XSDate(xmlCal.toGregorianCalendar(), res.tz());
            return res;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    private ResultSequence minusXSYearMonthDuration(AnyType at) {
        XSYearMonthDuration val = (XSYearMonthDuration)at;
        try {
            XSDate res = (XSDate)this.clone();
            res.calendar().add(2, val.monthValue() * -1);
            return res;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    private ResultSequence minusXSDate(ResultSequence arg) throws DynamicError {
        XSDate val = (XSDate)NumericType.get_single_type(arg, XSDate.class);
        Duration dtduration = null;
        Calendar thisCal = this.normalizeCalendar(this.calendar(), this.tz());
        Calendar thatCal = this.normalizeCalendar(val.calendar(), val.tz());
        long duration = thisCal.getTimeInMillis() - thatCal.getTimeInMillis();
        dtduration = _datatypeFactory.newDuration(duration);
        return XSDayTimeDuration.parseDTDuration(dtduration.toString());
    }

    @Override
    public ResultSequence plus(ResultSequence arg) throws DynamicError {
        if (arg.size() != 1) {
            DynamicError.throw_type_error();
        }
        Item at = arg.first();
        try {
            if (at instanceof XSYearMonthDuration) {
                XSYearMonthDuration val = (XSYearMonthDuration)at;
                XSDate res = (XSDate)this.clone();
                res.calendar().add(2, val.monthValue());
                return res;
            }
            if (at instanceof XSDayTimeDuration) {
                XSDayTimeDuration val = (XSDayTimeDuration)at;
                XSDate res = (XSDate)this.clone();
                int days = val.days();
                if (val.negative()) {
                    days *= -1;
                }
                res.calendar().add(5, days);
                res.calendar().add(14, (int)(val.time_value() * 1000.0));
                return res;
            }
            DynamicError.throw_type_error();
            return null;
        }
        catch (CloneNotSupportedException err) {
            assert (false);
            return null;
        }
    }

    @Override
    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_DATE;
    }
}

