/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.types;

import info.fingo.xactus.api.DynamicContext;
import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.api.typesystem.TypeDefinition;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.function.CmpEq;
import info.fingo.xactus.processor.internal.function.CmpGt;
import info.fingo.xactus.processor.internal.function.CmpLt;
import info.fingo.xactus.processor.internal.types.AnyType;
import info.fingo.xactus.processor.internal.types.CalendarType;
import info.fingo.xactus.processor.internal.types.CtrType;
import info.fingo.xactus.processor.internal.types.NumericType;
import info.fingo.xactus.processor.internal.types.XSAnyURI;
import info.fingo.xactus.processor.internal.types.XSBase64Binary;
import info.fingo.xactus.processor.internal.types.XSDuration;
import info.fingo.xactus.processor.internal.types.XSHexBinary;
import info.fingo.xactus.processor.internal.types.builtin.BuiltinTypeLibrary;

public class XSBoolean
extends CtrType
implements CmpEq,
CmpGt,
CmpLt {
    private static final String XS_BOOLEAN = "xs:boolean";
    public static final XSBoolean TRUE = new XSBoolean(true);
    public static final XSBoolean FALSE = new XSBoolean(false);
    private final boolean _value;

    private XSBoolean(boolean x) {
        this._value = x;
    }

    public XSBoolean() {
        this(false);
    }

    @Override
    public String string_type() {
        return XS_BOOLEAN;
    }

    @Override
    public Object getNativeValue() {
        return this._value;
    }

    @Override
    public String type_name() {
        return "boolean";
    }

    @Override
    public String getStringValue() {
        return "" + this._value;
    }

    public boolean value() {
        return this._value;
    }

    @Override
    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        Item anyType = arg.first();
        if (anyType instanceof XSDuration || anyType instanceof CalendarType || anyType instanceof XSBase64Binary || anyType instanceof XSHexBinary || anyType instanceof XSAnyURI) {
            throw DynamicError.invalidType();
        }
        String str_value = anyType.getStringValue();
        if (!this.isCastable(anyType, str_value)) {
            throw DynamicError.cant_cast(null);
        }
        return XSBoolean.valueOf(!this.isFalse(str_value));
    }

    private boolean isFalse(String str_value) {
        return str_value.equals("0") || str_value.equals("false") || str_value.equals("+0") || str_value.equals("-0") || str_value.equals("0.0E0") || str_value.equals("NaN");
    }

    private boolean isCastable(Item anyType, String str_value) {
        return str_value.equals("0") || str_value.equals("1") || str_value.equals("true") || str_value.equals("false") || anyType instanceof NumericType;
    }

    @Override
    public boolean eq(AnyType arg, DynamicContext dynamicContext) throws DynamicError {
        XSBoolean barg = (XSBoolean)NumericType.get_single_type((Item)arg, XSBoolean.class);
        return this.value() == barg.value();
    }

    @Override
    public boolean gt(AnyType arg, DynamicContext context) throws DynamicError {
        XSBoolean barg = (XSBoolean)NumericType.get_single_type((Item)arg, XSBoolean.class);
        boolean result = false;
        if (this.value() && !barg.value()) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean lt(AnyType arg, DynamicContext context) throws DynamicError {
        XSBoolean barg = (XSBoolean)NumericType.get_single_type((Item)arg, XSBoolean.class);
        boolean result = false;
        if (!this.value() && barg.value()) {
            result = true;
        }
        return result;
    }

    @Override
    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_BOOLEAN;
    }

    public static ResultSequence valueOf(boolean answer) {
        return answer ? TRUE : FALSE;
    }
}

