/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.types;

import info.fingo.xactus.api.DynamicContext;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.api.typesystem.TypeDefinition;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.function.CmpEq;
import info.fingo.xactus.processor.internal.types.AnyAtomicType;
import info.fingo.xactus.processor.internal.types.AnyType;
import info.fingo.xactus.processor.internal.types.CalendarType;
import info.fingo.xactus.processor.internal.types.CtrType;
import info.fingo.xactus.processor.internal.types.NumericType;
import info.fingo.xactus.processor.internal.types.XSAnyURI;
import info.fingo.xactus.processor.internal.types.XSBoolean;
import info.fingo.xactus.processor.internal.types.XSDuration;
import info.fingo.xactus.processor.internal.types.XSHexBinary;
import info.fingo.xactus.processor.internal.types.XSString;
import info.fingo.xactus.processor.internal.types.XSUntypedAtomic;
import info.fingo.xactus.processor.internal.types.builtin.BuiltinTypeLibrary;
import java.nio.charset.StandardCharsets;
import org.apache.xerces.impl.dv.util.Base64;
import org.apache.xerces.impl.dv.util.HexBin;

public class XSBase64Binary
extends CtrType
implements CmpEq {
    private static final String XS_BASE64_BINARY = "xs:base64Binary";
    private String _value;

    public XSBase64Binary(String x) {
        this._value = x;
    }

    public XSBase64Binary() {
        this(null);
    }

    @Override
    public String string_type() {
        return XS_BASE64_BINARY;
    }

    @Override
    public String type_name() {
        return "base64Binary";
    }

    @Override
    public String getStringValue() {
        return this._value;
    }

    public String value() {
        return this._value;
    }

    @Override
    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        AnyAtomicType aat = (AnyAtomicType)arg.first();
        if (aat instanceof NumericType || aat instanceof XSDuration || aat instanceof CalendarType || aat instanceof XSBoolean || aat instanceof XSAnyURI) {
            throw DynamicError.invalidType();
        }
        if (!this.isCastable(aat)) {
            throw DynamicError.cant_cast(null);
        }
        String str_value = aat.getStringValue();
        byte[] decodedValue = Base64.decode(str_value);
        if (aat instanceof XSHexBinary) {
            decodedValue = HexBin.decode(str_value);
            decodedValue = Base64.encode(decodedValue).getBytes();
        } else {
            decodedValue = str_value.getBytes();
        }
        if (decodedValue != null) {
            return new XSBase64Binary(new String(decodedValue, StandardCharsets.UTF_8));
        }
        throw DynamicError.throw_type_error();
    }

    private boolean isCastable(AnyAtomicType aat) {
        if (aat instanceof XSString || aat instanceof XSUntypedAtomic) {
            return true;
        }
        return aat instanceof XSBase64Binary || aat instanceof XSHexBinary;
    }

    @Override
    public boolean eq(AnyType arg, DynamicContext dynamicContext) throws DynamicError {
        String valToCompare = arg.getStringValue();
        byte[] value1 = Base64.decode(this._value);
        byte[] value2 = Base64.decode(valToCompare);
        if (value2 == null) {
            return false;
        }
        int len = value1.length;
        if (len != value2.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (value1[i] == value2[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_BASE64BINARY;
    }

    @Override
    public Object getNativeValue() {
        return Base64.decode(this._value);
    }
}

