/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.types;

import info.fingo.xactus.api.DynamicContext;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.api.typesystem.TypeDefinition;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.function.CmpEq;
import info.fingo.xactus.processor.internal.function.CmpGt;
import info.fingo.xactus.processor.internal.function.CmpLt;
import info.fingo.xactus.processor.internal.types.AnyType;
import info.fingo.xactus.processor.internal.types.CtrType;
import info.fingo.xactus.processor.internal.types.XSString;
import info.fingo.xactus.processor.internal.types.builtin.BuiltinTypeLibrary;

public class XSAnyURI
extends CtrType
implements CmpEq,
CmpGt,
CmpLt {
    private static final String XS_ANY_URI = "xs:anyURI";
    private String _value;

    public XSAnyURI(String x) {
        this._value = x;
    }

    public XSAnyURI() {
        this(null);
    }

    @Override
    public String string_type() {
        return XS_ANY_URI;
    }

    @Override
    public String type_name() {
        return "anyURI";
    }

    @Override
    public String string_value() {
        return this._value;
    }

    @Override
    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        AnyType aat = (AnyType)arg.first();
        if (!(aat.string_type().equals("xs:string") || aat.string_type().equals(XS_ANY_URI) || aat.string_type().equals("xs:untypedAtomic"))) {
            throw DynamicError.invalidType();
        }
        return new XSAnyURI(aat.string_value());
    }

    @Override
    public boolean eq(AnyType arg, DynamicContext dynamicContext) throws DynamicError {
        if (arg instanceof XSAnyURI || arg instanceof XSString) {
            return this.string_value().equals(arg.string_value());
        }
        throw DynamicError.throw_type_error();
    }

    @Override
    public boolean gt(AnyType arg, DynamicContext context) throws DynamicError {
        String compareToURI;
        if (!(arg instanceof XSAnyURI) && !(arg instanceof XSString)) {
            throw DynamicError.throw_type_error();
        }
        String anyURI = this.string_value();
        return anyURI.compareTo(compareToURI = arg.string_value()) > 0;
    }

    @Override
    public boolean lt(AnyType arg, DynamicContext context) throws DynamicError {
        String compareToURI;
        if (!(arg instanceof XSAnyURI) && !(arg instanceof XSString)) {
            throw DynamicError.throw_type_error();
        }
        String anyURI = this.string_value();
        return anyURI.compareTo(compareToURI = arg.string_value()) < 0;
    }

    @Override
    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_ANYURI;
    }

    @Override
    public String getStringValue() {
        return this._value;
    }
}

