/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.types;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public final class XPathDecimalFormat {
    private static final String NEG_INFINITY = "-INF";
    private static final String POS_INFINITY = "INF";
    private static final DecimalFormatSymbols SYMBOLS_US = new DecimalFormatSymbols(Locale.US);
    private static final String XS_FLOAT_DEFAULT_FORMAT = "0.#######E0";
    private static final String XS_FLOAT_FORMAT_2 = "0.#######E0".replaceAll("E0", "");
    private static final String XS_FLOAT_FORMAT_3 = "0.#######E0".replaceAll("0\\.#", "0.0");
    private static final String XS_DOUBLE_DEFAULT_FORMAT = "0.################E0";
    private static final String XS_DOUBLE_FORMAT_2 = "0.################E0".replaceAll("E0", "");
    private static final String XS_DOUBLE_FORMAT_3 = "0.################E0".replaceAll("0\\.#", "0.0");
    private static final String XS_DECIMAL_FORMAT = "0.####################";
    private static final ThreadLocal<DecimalFormat> XS_FLOAT_DEFAULT_DECIMAL_FORMAT = XPathDecimalFormat.threadLocalizedDecimalFormat("0.#######E0");
    private static final ThreadLocal<DecimalFormat> XS_FLOAT_DECIMAL_FORMAT_2 = XPathDecimalFormat.threadLocalizedDecimalFormat(XS_FLOAT_FORMAT_2);
    private static final ThreadLocal<DecimalFormat> XS_FLOAT_DECIMAL_FORMAT_3 = XPathDecimalFormat.threadLocalizedDecimalFormat(XS_FLOAT_FORMAT_3);
    private static final ThreadLocal<DecimalFormat> XS_DOUBLE_DECIMAL_FORMAT_2 = XPathDecimalFormat.threadLocalizedDecimalFormat(XS_DOUBLE_FORMAT_2);
    private static final ThreadLocal<DecimalFormat> XS_DOUBLE_DECIMAL_FORMAT_3 = XPathDecimalFormat.threadLocalizedDecimalFormat(XS_DOUBLE_FORMAT_3);
    private static final ThreadLocal<DecimalFormat> XS_DECIMAL_DECIMAL_FORMAT = XPathDecimalFormat.threadLocalizedDecimalFormat("0.####################");

    private XPathDecimalFormat() {
    }

    public static String xpathFormat(Object obj) {
        if (obj instanceof Float) {
            return XPathDecimalFormat.formatFloatValue((Float)obj);
        }
        if (obj instanceof Double) {
            return XPathDecimalFormat.formatDoubleValue(obj);
        }
        return XS_DECIMAL_DECIMAL_FORMAT.get().format(obj);
    }

    private static String formatDoubleValue(Object obj) {
        Double doubleValue = (Double)obj;
        if (doubleValue == Double.NEGATIVE_INFINITY) {
            return NEG_INFINITY;
        }
        if (doubleValue == Double.POSITIVE_INFINITY) {
            return POS_INFINITY;
        }
        DecimalFormat decimalFormat = XPathDecimalFormat.doubleXPathPattern(obj);
        return decimalFormat.format(obj);
    }

    private static DecimalFormat doubleXPathPattern(Object obj) {
        BigDecimal doubleValue = BigDecimal.valueOf((Double)obj);
        BigDecimal minValue = new BigDecimal("-1E6");
        BigDecimal maxValue = new BigDecimal("1E6");
        if (doubleValue.compareTo(minValue) > 0 && doubleValue.compareTo(maxValue) < 0) {
            return XS_DOUBLE_DECIMAL_FORMAT_2.get();
        }
        return XS_DOUBLE_DECIMAL_FORMAT_3.get();
    }

    private static String formatFloatValue(Float floatValue) {
        if (floatValue.floatValue() == Float.NEGATIVE_INFINITY) {
            return NEG_INFINITY;
        }
        if (floatValue.floatValue() == Float.POSITIVE_INFINITY) {
            return POS_INFINITY;
        }
        return XPathDecimalFormat.floatXPathPattern(floatValue).format(floatValue);
    }

    private static DecimalFormat floatXPathPattern(Float floatValue) {
        if (floatValue.floatValue() > -1000000.0f && floatValue.floatValue() < 1000000.0f) {
            return XS_FLOAT_DECIMAL_FORMAT_2.get();
        }
        if (floatValue.floatValue() <= -1000000.0f) {
            return XS_FLOAT_DECIMAL_FORMAT_3.get();
        }
        return XS_FLOAT_DEFAULT_DECIMAL_FORMAT.get();
    }

    private static ThreadLocal<DecimalFormat> threadLocalizedDecimalFormat(String pattern) {
        return ThreadLocal.withInitial(() -> new DecimalFormat(pattern, SYMBOLS_US));
    }
}

