/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.types;

import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.typesystem.ComplexTypeDefinition;
import info.fingo.xactus.api.typesystem.PrimitiveType;
import info.fingo.xactus.api.typesystem.SimpleTypeDefinition;
import info.fingo.xactus.api.typesystem.TypeDefinition;
import info.fingo.xactus.api.typesystem.TypeModel;
import info.fingo.xactus.processor.PsychoPathTypeHelper;
import info.fingo.xactus.processor.ResultSequence;
import info.fingo.xactus.processor.internal.types.AnyType;
import info.fingo.xactus.processor.internal.types.AttrType;
import info.fingo.xactus.processor.internal.types.CommentType;
import info.fingo.xactus.processor.internal.types.DocType;
import info.fingo.xactus.processor.internal.types.ElementType;
import info.fingo.xactus.processor.internal.types.PIType;
import info.fingo.xactus.processor.internal.types.QName;
import info.fingo.xactus.processor.internal.types.SchemaTypeValueFactory;
import info.fingo.xactus.processor.internal.types.TextType;
import info.fingo.xactus.processor.internal.types.XSUntypedAtomic;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;

public abstract class NodeType
extends AnyType {
    protected static final String SCHEMA_TYPE_IDREF = "IDREF";
    protected static final String SCHEMA_TYPE_ID = "ID";
    private Node _node;
    protected TypeModel _typeModel;
    private static final Comparator NODE_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return NodeType.compare_node((NodeType)o1, (NodeType)o2);
        }
    };

    public NodeType(Node node, TypeModel tm) {
        this._node = node;
        this._typeModel = tm;
    }

    public Node node_value() {
        return this._node;
    }

    public abstract info.fingo.xactus.api.ResultSequence typed_value();

    public abstract QName node_name();

    public info.fingo.xactus.api.ResultSequence nilled() {
        return ResultBuffer.EMPTY;
    }

    public static NodeType dom_to_xpath(Node node, TypeModel tm) {
        assert (node != null);
        switch (node.getNodeType()) {
            case 1: {
                return new ElementType((Element)node, tm);
            }
            case 8: {
                return new CommentType((Comment)node, tm);
            }
            case 2: {
                return new AttrType((Attr)node, tm);
            }
            case 3: 
            case 4: {
                return new TextType((Text)node, tm);
            }
            case 9: {
                return new DocType((Document)node, tm);
            }
            case 7: {
                return new PIType((ProcessingInstruction)node, tm);
            }
        }
        return null;
    }

    public static ResultSequence eliminate_dups(ResultSequence rs) {
        Hashtable<Node, Boolean> added = new Hashtable<Node, Boolean>(rs.size());
        ListIterator i = rs.iterator();
        while (i.hasNext()) {
            NodeType node = (NodeType)i.next();
            Node n = node.node_value();
            if (added.containsKey(n)) {
                i.remove();
                continue;
            }
            added.put(n, Boolean.TRUE);
        }
        return rs;
    }

    public static info.fingo.xactus.api.ResultSequence sort_document_order(ResultSequence rs) {
        ResultBuffer res = new ResultBuffer();
        for (NodeType node : rs) {
            boolean added = false;
            for (int j = 0; j < res.size(); ++j) {
                NodeType x = (NodeType)res.item(j);
                if (!NodeType.before(node, x)) continue;
                res.addAt(j, node);
                added = true;
                break;
            }
            if (added) continue;
            res.add(node);
        }
        ResultBuffer rb = new ResultBuffer();
        ListIterator<Item> i = res.iterator();
        while (i.hasNext()) {
            NodeType node = (NodeType)i.next();
            rb.add(node);
        }
        return rb.getSequence();
    }

    public static boolean same(NodeType a, NodeType b) {
        return a.node_value().isSameNode(b.node_value());
    }

    public boolean before(NodeType two) {
        return NodeType.before(this, two);
    }

    public static boolean before(NodeType a, NodeType b) {
        return NodeType.compare_node(a, b) < 0;
    }

    public boolean after(NodeType two) {
        return NodeType.after(this, two);
    }

    public static boolean after(NodeType a, NodeType b) {
        return NodeType.compare_node(a, b) > 0;
    }

    private static int compare_node(NodeType a, NodeType b) {
        Document docB;
        Node nodeB;
        Node nodeA = a.node_value();
        if (nodeA == (nodeB = b.node_value()) || nodeA.isSameNode(nodeB)) {
            return 0;
        }
        Document docA = NodeType.getDocument(nodeA);
        if (docA != (docB = NodeType.getDocument(nodeB)) && !docA.isSameNode(docB)) {
            return NodeType.compareDocuments(docA, docB);
        }
        short relation = nodeA.compareDocumentPosition(nodeB);
        if ((relation & 2) != 0) {
            return 1;
        }
        if ((relation & 4) != 0) {
            return -1;
        }
        throw new RuntimeException("Unexpected result from node comparison: " + relation);
    }

    private static int compareDocuments(Document docA, Document docB) {
        if (docB.getDocumentURI() == null || docA.getDocumentURI() == null) {
            throw new UnsupportedOperationException("Unable to deterministically order documents with no URI set.");
        }
        return docA.getDocumentURI().compareTo(docB.getDocumentURI());
    }

    private static Document getDocument(Node nodeA) {
        return nodeA instanceof Document ? (Document)nodeA : nodeA.getOwnerDocument();
    }

    protected Object getTypedValueForPrimitiveType(TypeDefinition typeDef) {
        String strValue = this.getStringValue();
        if (typeDef == null) {
            return new XSUntypedAtomic(strValue);
        }
        return SchemaTypeValueFactory.newSchemaTypeValue(PsychoPathTypeHelper.getXSDTypeShortCode(typeDef), strValue);
    }

    protected info.fingo.xactus.api.ResultSequence getXDMTypedValue(TypeDefinition typeDef, List itemValTypes) {
        if ("anySimpleType".equals(typeDef.getName()) || "anyAtomicType".equals(typeDef.getName())) {
            return new XSUntypedAtomic(this.getStringValue());
        }
        SimpleTypeDefinition simpType = null;
        if (typeDef instanceof ComplexTypeDefinition) {
            ComplexTypeDefinition complexTypeDefinition = (ComplexTypeDefinition)typeDef;
            simpType = complexTypeDefinition.getSimpleType();
            if (simpType != null) {
                return this.getTypedValueForSimpleContent(simpType, itemValTypes);
            }
            return new XSUntypedAtomic(this.getStringValue());
        }
        simpType = (SimpleTypeDefinition)typeDef;
        return this.getTypedValueForSimpleContent(simpType, itemValTypes);
    }

    private info.fingo.xactus.api.ResultSequence getTypedValueForSimpleContent(SimpleTypeDefinition simpType, List itemValueTypes) {
        ResultBuffer rs = new ResultBuffer();
        if (simpType.getVariety() == 1) {
            short shortCode = PsychoPathTypeHelper.getXSDTypeShortCode(simpType);
            AnyType schemaTypeValue = SchemaTypeValueFactory.newSchemaTypeValue(shortCode, this.getStringValue());
            if (schemaTypeValue != null) {
                QName qName;
                if (shortCode == 19 && !(qName = (QName)schemaTypeValue).expanded() && qName.prefix() != null) {
                    qName.set_namespace(this._node.lookupNamespaceURI(qName.prefix()));
                }
                return schemaTypeValue;
            }
            return new XSUntypedAtomic(this.getStringValue());
        }
        if (simpType.getVariety() == 2) {
            this.addAtomicListItemsToResultSet(simpType, itemValueTypes, rs);
        } else if (simpType.getVariety() == 3) {
            this.getTypedValueForVarietyUnion(simpType, rs);
        }
        return rs.getSequence();
    }

    private void addAtomicListItemsToResultSet(SimpleTypeDefinition simpType, List itemValueTypes, ResultBuffer rs) {
        block3: {
            SimpleTypeDefinition itemType;
            String[] listItemsStrValues;
            block2: {
                listItemsStrValues = this.getStringValue().split("\\s+");
                itemType = (SimpleTypeDefinition)simpType.getItemType();
                if (itemType.getVariety() != 1) break block2;
                for (int listItemIdx = 0; listItemIdx < listItemsStrValues.length; ++listItemIdx) {
                    rs.add(SchemaTypeValueFactory.newSchemaTypeValue(PsychoPathTypeHelper.getXSDTypeShortCode(itemType), listItemsStrValues[listItemIdx]));
                }
                break block3;
            }
            if (itemType.getVariety() != 3) break block3;
            for (int listItemIdx = 0; listItemIdx < listItemsStrValues.length; ++listItemIdx) {
                String listItem = listItemsStrValues[listItemIdx];
                rs.add(SchemaTypeValueFactory.newSchemaTypeValue((Short)itemValueTypes.get(listItemIdx), listItem));
            }
        }
    }

    private void getTypedValueForVarietyUnion(SimpleTypeDefinition simpType, ResultBuffer rs) {
        List memberTypes = simpType.getMemberTypes();
        for (int memTypeIdx = 0; memTypeIdx < memberTypes.size(); ++memTypeIdx) {
            PrimitiveType memSimpleType = (PrimitiveType)memberTypes.get(memTypeIdx);
            if (!this.isValueValidForSimpleType(this.getStringValue(), memSimpleType)) continue;
            rs.add(SchemaTypeValueFactory.newSchemaTypeValue(PsychoPathTypeHelper.getXSDTypeShortCode(memSimpleType), this.getStringValue()));
            break;
        }
    }

    private boolean isValueValidForSimpleType(String value, PrimitiveType simplType) {
        return simplType.validate(value);
    }

    public abstract boolean isID();

    public abstract boolean isIDREF();

    protected boolean isType(TypeInfo typeInfo, String typeName) {
        String typeInfoName;
        return typeInfo != null && (typeInfoName = typeInfo.getTypeName()) != null && typeInfo.getTypeName().equalsIgnoreCase(typeName);
    }

    protected TypeDefinition getType() {
        if (this._typeModel != null) {
            return this._typeModel.getType(this.node_value());
        }
        return null;
    }

    @Override
    public Object getNativeValue() {
        return this.node_value();
    }

    public TypeModel getTypeModel() {
        return this._typeModel;
    }

    public static ResultBuffer linarize(ResultBuffer rs) {
        TreeSet<Item> all = new TreeSet<Item>(NODE_COMPARATOR);
        all.addAll(rs.getCollection());
        return new ResultBuffer().concat(all);
    }
}

