/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.function;

import info.fingo.xactus.api.EvaluationContext;
import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.api.StaticContext;
import info.fingo.xactus.api.typesystem.TypeDefinition;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.SeqType;
import info.fingo.xactus.processor.internal.function.FnData;
import info.fingo.xactus.processor.internal.types.AnyAtomicType;
import info.fingo.xactus.processor.internal.types.AnyType;
import info.fingo.xactus.processor.internal.types.NumericType;
import info.fingo.xactus.processor.internal.types.QName;
import info.fingo.xactus.processor.internal.types.XSAnyURI;
import info.fingo.xactus.processor.internal.types.XSDouble;
import info.fingo.xactus.processor.internal.types.XSString;
import info.fingo.xactus.processor.internal.types.XSUntypedAtomic;
import info.fingo.xactus.processor.internal.types.builtin.BuiltinTypeLibrary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;

public abstract class Function
implements info.fingo.xactus.api.Function {
    protected static final DatatypeFactory _datatypeFactory;
    protected final QName name;
    protected final int min_arity;
    protected final int max_arity;

    public Function(QName name, int arity) {
        this.name = name;
        if (arity < 0) {
            throw new RuntimeException("We want to avoid this!");
        }
        this.min_arity = arity;
        this.max_arity = arity;
    }

    public Function(QName name, int min_arity, int max_arity) {
        this.name = name;
        if (min_arity < 0 || max_arity < 0 || max_arity < min_arity) {
            throw new RuntimeException("We want to avoid this!");
        }
        this.min_arity = min_arity;
        this.max_arity = max_arity;
    }

    public QName name() {
        return this.name;
    }

    public int min_arity() {
        return this.min_arity;
    }

    public int max_arity() {
        return this.max_arity;
    }

    public boolean matches_arity(int actual_arity) {
        if (actual_arity < this.min_arity()) {
            return false;
        }
        return actual_arity <= this.max_arity();
    }

    public String signature() {
        return Function.signature(this);
    }

    public static String signature(Function f) {
        return Function.signature(f.name(), f.is_vararg() ? -1 : f.min_arity());
    }

    public static String signature(QName name, int arity) {
        String n = name.expanded_name();
        if (n == null) {
            return null;
        }
        n = n + "_";
        n = arity < 0 ? n + "x" : n + arity;
        return n;
    }

    public ResultSequence evaluate(Collection args) throws DynamicError {
        throw new UnsupportedOperationException();
    }

    public static ResultSequence convert_argument(ResultSequence arg, SeqType expected) throws DynamicError {
        ResultBuffer result = new ResultBuffer();
        AnyType expected_type = expected.type();
        if (expected_type instanceof AnyAtomicType) {
            AnyAtomicType expected_aat = (AnyAtomicType)expected_type;
            ResultSequence rs = FnData.atomize(arg);
            for (Item i : rs) {
                AnyType item = (AnyType)i;
                if (item instanceof XSUntypedAtomic) {
                    AnyType converted = null;
                    if (expected_aat instanceof XSString) {
                        XSString strType = new XSString(item.getStringValue());
                        converted = strType;
                    } else {
                        converted = item;
                    }
                    result.concat(converted);
                    continue;
                }
                if (item instanceof XSAnyURI && expected_aat instanceof XSString) {
                    result.add(new XSString(item.getStringValue()));
                    continue;
                }
                if (item instanceof NumericType) {
                    if (expected_aat instanceof XSDouble) {
                        XSDouble doubleType = new XSDouble(item.getStringValue());
                        result.add(doubleType);
                        continue;
                    }
                    result.add(item);
                    continue;
                }
                result.add(item);
            }
            return expected.match(result.getSequence());
        }
        return expected.match(arg);
    }

    public static Collection convert_arguments(Collection args, Collection expected) throws DynamicError {
        ArrayList<ResultSequence> result = new ArrayList<ResultSequence>();
        assert (args.size() <= expected.size());
        Iterator argi = args.iterator();
        Iterator expi = expected.iterator();
        while (argi.hasNext()) {
            result.add(Function.convert_argument((ResultSequence)argi.next(), (SeqType)expi.next()));
        }
        return result;
    }

    protected static ResultSequence getResultSetForArityZero(EvaluationContext ec) throws DynamicError {
        Item contextItem = ec.getContextItem();
        if (contextItem != null) {
            return new XSString(contextItem.getStringValue());
        }
        throw DynamicError.contextUndefined();
    }

    public boolean is_vararg() {
        return this.min_arity != this.max_arity;
    }

    @Override
    public String getName() {
        return this.name().local();
    }

    @Override
    public int getMinArity() {
        return this.min_arity();
    }

    @Override
    public int getMaxArity() {
        return this.max_arity();
    }

    @Override
    public boolean isVariableArgument() {
        return this.is_vararg();
    }

    @Override
    public boolean canMatchArity(int actualArity) {
        return this.matches_arity(actualArity);
    }

    @Override
    public TypeDefinition getResultType() {
        return BuiltinTypeLibrary.XS_UNTYPED;
    }

    @Override
    public TypeDefinition getArgumentType(int index) {
        return BuiltinTypeLibrary.XS_UNTYPED;
    }

    @Override
    public String getArgumentNameHint(int index) {
        return "argument_" + index;
    }

    public TypeDefinition computeReturnType(Collection args, StaticContext sc) {
        return BuiltinTypeLibrary.XS_UNTYPED;
    }

    @Override
    public ResultSequence evaluate(Collection<ResultSequence> args, EvaluationContext evaluationContext) {
        ResultSequence result = this.evaluate(args);
        return result;
    }

    static {
        try {
            _datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException("Cannot initialize XML datatypes", e);
        }
    }
}

