/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.function;

import info.fingo.xactus.api.EvaluationContext;
import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.TypeError;
import info.fingo.xactus.processor.internal.function.FnData;
import info.fingo.xactus.processor.internal.function.Function;
import info.fingo.xactus.processor.internal.function.MathPlus;
import info.fingo.xactus.processor.internal.types.AnyAtomicType;
import info.fingo.xactus.processor.internal.types.AnyType;
import info.fingo.xactus.processor.internal.types.NumericType;
import info.fingo.xactus.processor.internal.types.QName;
import info.fingo.xactus.processor.internal.types.XSDecimal;
import info.fingo.xactus.processor.internal.types.XSDouble;
import info.fingo.xactus.processor.internal.types.XSFloat;
import info.fingo.xactus.processor.internal.types.XSUntypedAtomic;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class FsPlus
extends Function {
    public FsPlus() {
        super(new QName("plus"), 2);
    }

    public ResultSequence evaluate(Collection args, EvaluationContext ec) {
        assert (args.size() >= this.min_arity() && args.size() <= this.max_arity());
        return FsPlus.fs_plus(args);
    }

    /*
     * WARNING - void declaration
     */
    private static Collection convert_args(Collection args) throws DynamicError {
        ArrayList<void> result = new ArrayList<void>();
        boolean has_float = false;
        boolean has_double = false;
        Iterator i = args.iterator();
        while (i.hasNext()) {
            void var6_6;
            ResultSequence rs = FnData.atomize((ResultSequence)i.next());
            if (rs.empty()) {
                return new ArrayList();
            }
            if (rs.size() > 1) {
                throw new DynamicError(TypeError.invalid_type(null));
            }
            AnyType anyType = (AnyType)rs.item(0);
            if (anyType instanceof XSUntypedAtomic) {
                XSDouble xSDouble = new XSDouble(anyType.getStringValue());
            }
            if (var6_6 instanceof XSDouble) {
                has_double = true;
            }
            if (var6_6 instanceof XSFloat) {
                has_float = true;
            }
            result.add(var6_6);
        }
        if (has_double) {
            has_float = false;
        }
        if (has_double || has_float) {
            ArrayList<Item> result2 = new ArrayList<Item>();
            for (ResultSequence resultSequence : result) {
                Item arg = resultSequence.item(0);
                if (has_double && arg instanceof XSFloat) {
                    arg = new XSDouble(((XSFloat)arg).float_value());
                } else if (has_double && arg instanceof XSDecimal) {
                    arg = new XSDouble(((XSDecimal)arg).getValue().doubleValue());
                } else if (has_float && arg instanceof XSDecimal) {
                    arg = new XSFloat(((XSDecimal)arg).getValue().floatValue());
                }
                result2.add(arg);
            }
            return result2;
        }
        return result;
    }

    public static ResultSequence fs_plus(Collection args) throws DynamicError {
        return FsPlus.do_math_op(args, MathPlus.class, "plus");
    }

    public static ResultSequence fs_plus_unary(Collection args) throws DynamicError {
        AnyAtomicType at;
        ResultSequence arg;
        if (args.size() != 1) {
            DynamicError.throw_type_error();
        }
        if ((arg = (ResultSequence)args.iterator().next()).size() != 1) {
            DynamicError.throw_type_error();
        }
        if (!((at = FnData.atomize(arg.first())) instanceof NumericType)) {
            DynamicError.throw_type_error();
        }
        return arg;
    }

    public static ResultSequence do_math_op(Collection args, Class type, String mname) throws DynamicError {
        Collection cargs;
        if (args.size() != 2) {
            DynamicError.throw_type_error();
        }
        if ((cargs = FsPlus.convert_args(args)).size() == 0) {
            return ResultBuffer.EMPTY;
        }
        Iterator argi = cargs.iterator();
        Item arg = ((ResultSequence)argi.next()).item(0);
        ResultSequence arg2 = (ResultSequence)argi.next();
        if (!type.isInstance(arg)) {
            DynamicError.throw_type_error();
        }
        try {
            Class[] margsdef = new Class[]{ResultSequence.class};
            Method method = null;
            method = type.getMethod(mname, margsdef);
            Object[] margs = new Object[]{arg2};
            return (ResultSequence)method.invoke((Object)arg, margs);
        }
        catch (NoSuchMethodException err) {
            System.out.println("NoSuchMethodException: " + err.getMessage());
            assert (false);
        }
        catch (IllegalAccessException err) {
            System.out.println("IllegalAccessException: " + err.getMessage());
            assert (false);
        }
        catch (InvocationTargetException err) {
            Throwable ex = err.getTargetException();
            if (ex instanceof DynamicError) {
                throw (DynamicError)ex;
            }
            throw new RuntimeException(ex);
        }
        return null;
    }
}

