/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.function;

import com.ibm.icu.lang.UCharacter;
import info.fingo.xactus.api.EvaluationContext;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.SeqType;
import info.fingo.xactus.processor.internal.function.Function;
import info.fingo.xactus.processor.internal.types.QName;
import info.fingo.xactus.processor.internal.types.XSString;
import info.fingo.xactus.processor.internal.utils.StringCodePointIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class FnTranslate
extends Function {
    private static Collection _expected_args = null;

    public FnTranslate() {
        super(new QName("translate"), 3);
    }

    public ResultSequence evaluate(Collection args, EvaluationContext ec) throws DynamicError {
        return FnTranslate.translate(args);
    }

    public static ResultSequence translate(Collection args) throws DynamicError {
        Collection cargs = Function.convert_arguments(args, FnTranslate.expected_args());
        Iterator argi = cargs.iterator();
        ResultSequence arg1 = (ResultSequence)argi.next();
        ResultSequence arg2 = (ResultSequence)argi.next();
        ResultSequence arg3 = (ResultSequence)argi.next();
        if (arg1.empty()) {
            return new XSString("");
        }
        String str = ((XSString)arg1.first()).value();
        String mapstr = ((XSString)arg2.first()).value();
        String transstr = ((XSString)arg3.first()).value();
        Map replacements = FnTranslate.buildReplacementMap(mapstr, transstr);
        StringBuffer sb = new StringBuffer(str.length());
        StringCodePointIterator strIter = new StringCodePointIterator(str);
        int input = strIter.current();
        while (input != -1) {
            Integer inputCodepoint = new Integer(input);
            if (replacements.containsKey(inputCodepoint)) {
                Integer replaceWith = (Integer)replacements.get(inputCodepoint);
                if (replaceWith != null) {
                    sb.append(UCharacter.toChars(replaceWith));
                }
            } else {
                sb.append(UCharacter.toChars(input));
            }
            input = strIter.next();
        }
        return new XSString(sb.toString());
    }

    private static Map buildReplacementMap(String mapstr, String transstr) {
        HashMap<Integer, Integer> replacements = new HashMap<Integer, Integer>(mapstr.length() * 4);
        StringCodePointIterator mapIter = new StringCodePointIterator(mapstr);
        StringCodePointIterator transIter = new StringCodePointIterator(transstr);
        int mapFrom = mapIter.current();
        int mapTo = transIter.current();
        while (mapFrom != -1) {
            Integer codepointFrom = new Integer(mapFrom);
            if (!replacements.containsKey(codepointFrom)) {
                Integer replacement = mapTo != -1 ? new Integer(mapTo) : null;
                replacements.put(codepointFrom, replacement);
            }
            mapFrom = mapIter.next();
            mapTo = transIter.next();
        }
        return replacements;
    }

    public static synchronized Collection expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList();
            _expected_args.add(new SeqType(new XSString(), 3));
            _expected_args.add(new SeqType(new XSString(), 0));
            _expected_args.add(new SeqType(new XSString(), 0));
        }
        return _expected_args;
    }
}

