/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.function;

import info.fingo.xactus.api.EvaluationContext;
import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.TypeError;
import info.fingo.xactus.processor.internal.function.Function;
import info.fingo.xactus.processor.internal.function.MathPlus;
import info.fingo.xactus.processor.internal.types.AnyAtomicType;
import info.fingo.xactus.processor.internal.types.AnyType;
import info.fingo.xactus.processor.internal.types.QName;
import info.fingo.xactus.processor.internal.types.XSDouble;
import info.fingo.xactus.processor.internal.types.XSFloat;
import info.fingo.xactus.processor.internal.types.XSInteger;
import info.fingo.xactus.processor.internal.utils.ScalarTypePromoter;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;

public class FnSum
extends Function {
    private static XSInteger ZERO = new XSInteger(BigInteger.ZERO);

    public FnSum() {
        super(new QName("sum"), 1, 2);
    }

    public ResultSequence evaluate(Collection args, EvaluationContext ec) throws DynamicError {
        Iterator argIterator = args.iterator();
        ResultSequence argSequence = (ResultSequence)argIterator.next();
        AnyAtomicType zero = ZERO;
        if (argIterator.hasNext()) {
            ResultSequence zeroSequence = (ResultSequence)argIterator.next();
            if (zeroSequence.size() != 1) {
                throw new DynamicError(TypeError.invalid_type(null));
            }
            if (!(zeroSequence.first() instanceof AnyAtomicType)) {
                throw new DynamicError(TypeError.invalid_type(zeroSequence.first().getStringValue()));
            }
            zero = (AnyAtomicType)zeroSequence.first();
        }
        return FnSum.sum(argSequence, zero);
    }

    public static ResultSequence sum(ResultSequence arg, AnyAtomicType zero) throws DynamicError {
        if (arg.empty()) {
            return zero;
        }
        MathPlus total = null;
        ScalarTypePromoter tp = new ScalarTypePromoter();
        tp.considerSequence(arg);
        for (Item next : arg) {
            AnyAtomicType conv = tp.promote((AnyType)next);
            if (conv == null) {
                conv = zero;
            }
            if (conv instanceof XSDouble && ((XSDouble)conv).nan() || conv instanceof XSFloat && ((XSFloat)conv).nan()) {
                return tp.promote(new XSFloat(Float.NaN));
            }
            if (total == null) {
                total = (MathPlus)((Object)conv);
                continue;
            }
            total = (MathPlus)((Object)total.plus(conv).first());
        }
        return (AnyType)((Object)total);
    }
}

