/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.function;

import info.fingo.xactus.api.EvaluationContext;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.SeqType;
import info.fingo.xactus.processor.internal.function.Function;
import info.fingo.xactus.processor.internal.types.QName;
import info.fingo.xactus.processor.internal.types.XSInteger;
import info.fingo.xactus.processor.internal.types.XSString;
import info.fingo.xactus.processor.internal.utils.StringCodePointIterator;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;

public class FnStringToCodepoints
extends Function {
    private static Collection _expected_args = null;

    public FnStringToCodepoints() {
        super(new QName("string-to-codepoints"), 1);
    }

    public ResultSequence evaluate(Collection args, EvaluationContext ec) throws DynamicError {
        return FnStringToCodepoints.string_to_codepoints(args);
    }

    public static ResultSequence string_to_codepoints(Collection args) throws DynamicError {
        Collection cargs = Function.convert_arguments(args, FnStringToCodepoints.expected_args());
        ResultSequence arg1 = (ResultSequence)cargs.iterator().next();
        if (arg1.empty()) {
            return ResultBuffer.EMPTY;
        }
        XSString xstr = (XSString)arg1.first();
        StringCodePointIterator cpi = new StringCodePointIterator(xstr.value());
        ResultBuffer rs = new ResultBuffer();
        int codePoint = cpi.current();
        while (codePoint != -1) {
            rs.add(new XSInteger(BigInteger.valueOf(codePoint)));
            codePoint = cpi.next();
        }
        return rs.getSequence();
    }

    public static synchronized Collection expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList();
            _expected_args.add(new SeqType(new XSString(), 3));
        }
        return _expected_args;
    }
}

