/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.function;

import info.fingo.xactus.api.EvaluationContext;
import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.SeqType;
import info.fingo.xactus.processor.internal.function.Function;
import info.fingo.xactus.processor.internal.types.QName;
import info.fingo.xactus.processor.internal.types.XSAnyURI;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class FnResolveURI
extends Function {
    private static Collection _expected_args = null;

    public FnResolveURI() {
        super(new QName("resolve-uri"), 1, 2);
    }

    public ResultSequence evaluate(Collection args, EvaluationContext ec) throws DynamicError {
        return FnResolveURI.resolveURI(args, ec);
    }

    public static ResultSequence resolveURI(Collection args, EvaluationContext ec) throws DynamicError {
        if (ec.getStaticContext().getBaseUri() == null) {
            throw DynamicError.noBaseURI();
        }
        Collection cargs = args;
        Iterator argit = cargs.iterator();
        ResultSequence relativeRS = (ResultSequence)argit.next();
        ResultSequence baseUriRS = null;
        if (argit.hasNext()) {
            baseUriRS = (ResultSequence)argit.next();
        }
        if (relativeRS.empty()) {
            return ResultBuffer.EMPTY;
        }
        Item relativeURI = relativeRS.first();
        String resolvedURI = null;
        if (baseUriRS == null) {
            resolvedURI = FnResolveURI.resolveURI(ec.getStaticContext().getBaseUri().toString(), relativeURI.getStringValue());
        } else {
            Item baseURI = baseUriRS.first();
            resolvedURI = FnResolveURI.resolveURI(baseURI.getStringValue(), relativeURI.getStringValue());
        }
        return new XSAnyURI(resolvedURI);
    }

    private static String resolveURI(String base, String relative) throws DynamicError {
        String resolved = null;
        try {
            URI baseURI = new URI(base);
            resolved = baseURI.resolve(relative).toString();
        }
        catch (Exception ex) {
            throw DynamicError.errorResolvingURI();
        }
        return resolved;
    }

    public static synchronized Collection expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList();
            _expected_args.add(new SeqType(3));
            _expected_args.add(new SeqType(0));
        }
        return _expected_args;
    }
}

