/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.function;

import info.fingo.xactus.api.EvaluationContext;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.api.StaticContext;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.SeqType;
import info.fingo.xactus.processor.internal.function.Function;
import info.fingo.xactus.processor.internal.types.ElementType;
import info.fingo.xactus.processor.internal.types.QName;
import info.fingo.xactus.processor.internal.types.XSString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.w3c.dom.Element;

public class FnResolveQName
extends Function {
    private static Collection _expected_args = null;

    public FnResolveQName() {
        super(new QName("resolve-QName"), 2);
    }

    public ResultSequence evaluate(Collection args, EvaluationContext ec) throws DynamicError {
        return FnResolveQName.resolve_QName(args, ec.getStaticContext());
    }

    public static ResultSequence resolve_QName(Collection args, StaticContext sc) throws DynamicError {
        Collection cargs = args;
        Iterator argiter = cargs.iterator();
        ResultSequence arg1 = (ResultSequence)argiter.next();
        if (arg1.empty()) {
            return ResultBuffer.EMPTY;
        }
        ResultSequence arg2 = (ResultSequence)argiter.next();
        String name = ((XSString)arg1.first()).value();
        QName qn = QName.parse_QName(name);
        if (qn == null) {
            throw DynamicError.lexical_error(null);
        }
        ElementType xselement = (ElementType)arg2.first();
        Element element = (Element)xselement.node_value();
        if (qn.prefix() != null) {
            String namespaceURI = element.lookupNamespaceURI(qn.prefix());
            if (namespaceURI == null) {
                throw DynamicError.invalidPrefix();
            }
            qn.set_namespace(namespaceURI);
        } else if (qn.local().equals(element.getLocalName()) && element.isDefaultNamespace(element.getNamespaceURI())) {
            qn.set_namespace(element.getNamespaceURI());
        }
        return qn;
    }

    public static synchronized Collection expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList();
            SeqType arg = new SeqType(new XSString(), 3);
            _expected_args.add(arg);
            _expected_args.add(new SeqType(new ElementType(), 0));
        }
        return _expected_args;
    }
}

