/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.function;

import info.fingo.xactus.api.EvaluationContext;
import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.TypeError;
import info.fingo.xactus.processor.internal.function.FnData;
import info.fingo.xactus.processor.internal.function.Function;
import info.fingo.xactus.processor.internal.types.AnyAtomicType;
import info.fingo.xactus.processor.internal.types.NodeType;
import info.fingo.xactus.processor.internal.types.QName;
import info.fingo.xactus.processor.internal.types.XSDouble;
import info.fingo.xactus.processor.internal.types.XSFloat;
import java.util.Collection;

public class FnNumber
extends Function {
    public FnNumber() {
        super(new QName("number"), 0, 1);
    }

    public ResultSequence evaluate(Collection args, EvaluationContext ec) throws DynamicError {
        assert (args.size() >= this.min_arity() && args.size() <= this.max_arity());
        ResultSequence argument = null;
        argument = args.isEmpty() ? FnNumber.getResultSetForArityZero(ec) : (ResultSequence)args.iterator().next();
        return FnNumber.fn_number(argument, ec);
    }

    public static XSDouble fn_number(ResultSequence arg, EvaluationContext ec) throws DynamicError {
        if (arg.size() > 1) {
            throw new DynamicError(TypeError.invalid_type("bad argument passed to fn:number()"));
        }
        if (arg.size() == 1) {
            Item at = arg.first();
            if (at instanceof AnyAtomicType) {
                if (at instanceof XSDouble) {
                    return (XSDouble)at;
                }
                if (at instanceof XSFloat) {
                    float value = ((XSFloat)at).float_value();
                    if (Float.isNaN(value)) {
                        return new XSDouble(Double.NaN);
                    }
                    if (value == Float.NEGATIVE_INFINITY) {
                        return new XSDouble(Double.NEGATIVE_INFINITY);
                    }
                    if (value == Float.POSITIVE_INFINITY) {
                        return new XSDouble(Double.POSITIVE_INFINITY);
                    }
                    return new XSDouble(value);
                }
                XSDouble d = XSDouble.parse_double(at.getStringValue());
                return d != null ? d : new XSDouble(Double.NaN);
            }
            if (at instanceof NodeType) {
                XSDouble d = XSDouble.parse_double(FnData.atomize(at).getStringValue());
                return d != null ? d : new XSDouble(Double.NaN);
            }
        } else {
            return new XSDouble(Double.NaN);
        }
        return null;
    }
}

