/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.function;

import info.fingo.xactus.api.DynamicContext;
import info.fingo.xactus.api.EvaluationContext;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.SeqType;
import info.fingo.xactus.processor.internal.function.AbstractCollationEqualFunction;
import info.fingo.xactus.processor.internal.function.CmpEq;
import info.fingo.xactus.processor.internal.function.FnData;
import info.fingo.xactus.processor.internal.function.Function;
import info.fingo.xactus.processor.internal.types.AnyAtomicType;
import info.fingo.xactus.processor.internal.types.AnyType;
import info.fingo.xactus.processor.internal.types.NodeType;
import info.fingo.xactus.processor.internal.types.QName;
import info.fingo.xactus.processor.internal.types.XSInteger;
import info.fingo.xactus.processor.internal.types.XSString;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class FnIndexOf
extends AbstractCollationEqualFunction {
    private static Collection _expected_args = null;

    public FnIndexOf() {
        super(new QName("index-of"), 2, 3);
    }

    public ResultSequence evaluate(Collection args, EvaluationContext ec) {
        return FnIndexOf.index_of(args, ec.getDynamicContext());
    }

    private static AnyType get_comparable(AnyType at) throws DynamicError {
        if (at instanceof NodeType) {
            return FnData.atomize(at);
        }
        if (!(at instanceof AnyAtomicType)) {
            DynamicError.throw_type_error();
        }
        if (!(at instanceof CmpEq)) {
            throw DynamicError.not_cmp(null);
        }
        return at;
    }

    public static ResultSequence index_of(Collection args, DynamicContext dc) {
        ResultSequence arg3;
        Collection cargs = Function.convert_arguments(args, FnIndexOf.expected_args());
        Iterator citer = cargs.iterator();
        ResultSequence arg1 = (ResultSequence)citer.next();
        ResultSequence arg2 = (ResultSequence)citer.next();
        if (arg1.empty()) {
            return ResultBuffer.EMPTY;
        }
        if (arg2.size() != 1) {
            DynamicError.throw_type_error();
        }
        String collationUri = dc.getCollationProvider().getDefaultCollation();
        if (citer.hasNext() && !(arg3 = (ResultSequence)citer.next()).empty()) {
            XSString collation = (XSString)arg3.first();
            collationUri = collation.getStringValue();
        }
        ResultBuffer rb = new ResultBuffer();
        AnyType at = (AnyType)arg2.first();
        at = FnIndexOf.get_comparable(at);
        int index = 1;
        for (AnyType cmptype : arg1) {
            if (FnIndexOf.hasValue(cmptype = FnIndexOf.get_comparable(cmptype), at, dc, collationUri)) {
                rb.add(new XSInteger(BigInteger.valueOf(index)));
            }
            ++index;
        }
        return rb.getSequence();
    }

    public static synchronized Collection expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList();
            SeqType arg = new SeqType(AnyType.class, 1);
            _expected_args.add(arg);
            _expected_args.add(new SeqType(AnyType.class, 0));
            _expected_args.add(new SeqType(new XSString(), 0));
            _expected_args.add(arg);
        }
        return _expected_args;
    }
}

