/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.xactus.processor.internal.function;

import info.fingo.xactus.api.DynamicContext;
import info.fingo.xactus.api.EvaluationContext;
import info.fingo.xactus.api.Item;
import info.fingo.xactus.api.ResultBuffer;
import info.fingo.xactus.api.ResultSequence;
import info.fingo.xactus.processor.DynamicError;
import info.fingo.xactus.processor.internal.function.AbstractCollationEqualFunction;
import info.fingo.xactus.processor.internal.function.CmpEq;
import info.fingo.xactus.processor.internal.function.FnData;
import info.fingo.xactus.processor.internal.types.AnyAtomicType;
import info.fingo.xactus.processor.internal.types.QName;
import info.fingo.xactus.processor.internal.types.XSString;
import info.fingo.xactus.processor.internal.types.XSUntypedAtomic;
import java.util.Collection;
import java.util.Iterator;

public class FnDistinctValues
extends AbstractCollationEqualFunction {
    public FnDistinctValues() {
        super(new QName("distinct-values"), 1, 2);
    }

    public ResultSequence evaluate(Collection args, EvaluationContext ec) throws DynamicError {
        return FnDistinctValues.distinct_values(args, ec.getDynamicContext());
    }

    public static ResultSequence distinct_values(Collection args, DynamicContext context) throws DynamicError {
        ResultBuffer rs = new ResultBuffer();
        Iterator citer = args.iterator();
        ResultSequence arg1 = (ResultSequence)citer.next();
        ResultSequence arg2 = ResultBuffer.EMPTY;
        if (citer.hasNext()) {
            arg2 = (ResultSequence)citer.next();
        }
        String collationURI = context.getCollationProvider().getDefaultCollation();
        if (!arg2.empty()) {
            XSString collation = (XSString)arg2.item(0);
            collationURI = collation.getStringValue();
        }
        Iterator iter = arg1.iterator();
        while (iter.hasNext()) {
            AnyAtomicType atomizedItem = FnData.atomize((Item)iter.next());
            if (FnDistinctValues.contains(rs, atomizedItem, context, collationURI)) continue;
            rs.add(atomizedItem);
        }
        return rs.getSequence();
    }

    protected static boolean contains(ResultBuffer rs, AnyAtomicType item, DynamicContext context, String collationURI) {
        if (!(item instanceof CmpEq) && !(item instanceof XSUntypedAtomic)) {
            return false;
        }
        return FnDistinctValues.hasValue(rs, item, context, collationURI, true);
    }
}

